/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.serialization;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.asm.ClassWriter;
import org.springframework.asm.FieldVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Opcodes;
import org.springframework.asm.Type;
import org.springframework.beans.BeanUtils;
import org.springframework.data.gemfire.serialization.InstantiatorGenerator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmInstantiatorGenerator
implements InstantiatorGenerator,
Opcodes {
    private static final String PKG = "org/springextensions/gef/serialization";
    private static final String CLASS_LABEL = "Instantiator$Synthetic";
    private static final String INSTANTIATOR_NAME = Type.getInternalName(Instantiator.class);
    private static final String SERIALIZABLE_NAME = Type.getInternalName(Serializable.class);
    private static final String CLASS_DESCRIPTOR = Type.getDescriptor(Class.class);
    private static final String CLASS_FIELD_NAME = "clazz";
    private static final String ID_FIELD_NAME = "classId";
    private static final String INIT = "<init>";
    private static final String CINIT = "<clinit>";
    private static final String NEW_INSTANCE = "newInstance";
    private static final String NEW_INSTANCE_DESC = Type.getMethodDescriptor((Type)Type.getType(DataSerializable.class), (Type[])new Type[0]);
    private static final AtomicLong counter = new AtomicLong(1L);
    private final ConcurrentMap<Class<? extends DataSerializable>, Instantiator> cache = new ConcurrentHashMap<Class<? extends DataSerializable>, Instantiator>();
    private final BytecodeClassLoader classLoader;

    public AsmInstantiatorGenerator() {
        this(AsmInstantiatorGenerator.class.getClassLoader());
    }

    public AsmInstantiatorGenerator(final ClassLoader classLoader) {
        Assert.notNull((Object)classLoader);
        this.classLoader = AccessController.doPrivileged(new PrivilegedAction<BytecodeClassLoader>(){

            @Override
            public BytecodeClassLoader run() {
                return new BytecodeClassLoader(classLoader);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instantiator getInstantiator(Class<? extends DataSerializable> clazz, int classId) {
        Instantiator instantiator = (Instantiator)this.cache.get(clazz);
        if (instantiator == null) {
            ConcurrentMap<Class<? extends DataSerializable>, Instantiator> concurrentMap = this.cache;
            synchronized (concurrentMap) {
                instantiator = (Instantiator)this.cache.get(clazz);
                if (instantiator == null) {
                    instantiator = this.createInstantiator(clazz, classId);
                    this.cache.putIfAbsent(clazz, instantiator);
                }
            }
        }
        return instantiator;
    }

    private Instantiator createInstantiator(Class<? extends DataSerializable> clazz, int classId) {
        this.validateClass(clazz);
        Class<?> clz = this.createCustomInstantiatorClass(clazz, classId);
        return (Instantiator)BeanUtils.instantiate(clz);
    }

    private void validateClass(Class<? extends DataSerializable> clazz) {
        Assert.isTrue((!Modifier.isAbstract(clazz.getModifiers()) ? 1 : 0) != 0, (String)"Cannot instantiate abstract classes");
        Assert.isTrue((boolean)Modifier.isPublic(clazz.getModifiers()), (String)"Only public classes are supported");
        try {
            Constructor<? extends DataSerializable> ctor = clazz.getConstructor(new Class[0]);
            Assert.isTrue((boolean)Modifier.isPublic(ctor.getModifiers()), (String)"Default constructor is not public");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Class " + clazz + " unsuitable for instantiation", ex);
        }
    }

    Class<?> createCustomInstantiatorClass(Class<? extends DataSerializable> clazz, int classId) {
        String classInternalName = PKG + clazz.getSimpleName() + CLASS_LABEL + counter.getAndIncrement();
        byte[] bytecode = this.generateClassBytecode(classInternalName, clazz, classId);
        return this.classLoader.loadClass(classInternalName.replace('/', '.'), bytecode);
    }

    byte[] generateClassBytecode(String className, Class<? extends DataSerializable> clazz, int classId) {
        ClassWriter cw = new ClassWriter(false);
        cw.visit(49, 33, className, null, INSTANTIATOR_NAME, new String[]{SERIALIZABLE_NAME});
        FieldVisitor fv = cw.visitField(26, CLASS_FIELD_NAME, CLASS_DESCRIPTOR, null, null);
        fv.visitEnd();
        fv = cw.visitField(26, ID_FIELD_NAME, Type.INT_TYPE.getDescriptor(), null, (Object)classId);
        fv.visitEnd();
        String voidNoArgMethodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        MethodVisitor mv = cw.visitMethod(8, CINIT, voidNoArgMethodDescriptor, null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)Type.getType(clazz));
        mv.visitFieldInsn(179, className, CLASS_FIELD_NAME, CLASS_DESCRIPTOR);
        mv.visitInsn(177);
        mv.visitMaxs(1, 0);
        mv.visitEnd();
        String voidArgClassAndIntDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Class.class), Type.INT_TYPE});
        mv = cw.visitMethod(1, INIT, voidNoArgMethodDescriptor, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, className, CLASS_FIELD_NAME, CLASS_DESCRIPTOR);
        mv.visitFieldInsn(178, className, ID_FIELD_NAME, Type.INT_TYPE.getDescriptor());
        mv.visitMethodInsn(183, className, INIT, voidArgClassAndIntDescriptor);
        mv.visitInsn(177);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, INIT, voidArgClassAndIntDescriptor, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, INSTANTIATOR_NAME, INIT, voidArgClassAndIntDescriptor);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        Type customClassType = Type.getType(clazz);
        String customTypeNoArgDesc = Type.getMethodDescriptor((Type)customClassType, (Type[])new Type[0]);
        mv = cw.visitMethod(1, NEW_INSTANCE, customTypeNoArgDesc, null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, customClassType.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, customClassType.getInternalName(), INIT, voidNoArgMethodDescriptor);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, NEW_INSTANCE, NEW_INSTANCE_DESC, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, className, NEW_INSTANCE, customTypeNoArgDesc);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BytecodeClassLoader
    extends ClassLoader {
        public BytecodeClassLoader(ClassLoader loader) {
            super(loader);
        }

        public Class<?> loadClass(String name, byte[] bytecode) {
            return this.defineClass(name, bytecode, 0, bytecode.length);
        }
    }
}

