/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.client.PoolConnection;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PoolParser
extends AbstractSimpleBeanDefinitionParser {
    PoolParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return PoolFactoryBean.class;
    }

    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
        List subElements = DomUtils.getChildElements((Element)element);
        ManagedList locators = new ManagedList(subElements.size());
        ManagedList servers = new ManagedList(subElements.size());
        for (Element subElement : subElements) {
            String name = subElement.getLocalName();
            if ("locator".equals(name)) {
                locators.add(this.parseLocator(subElement));
            }
            if (!"server".equals(name)) continue;
            servers.add(this.parseServer(subElement));
        }
        if (!locators.isEmpty()) {
            builder.addPropertyValue("locators", (Object)locators);
        }
        if (!servers.isEmpty()) {
            builder.addPropertyValue("servers", (Object)servers);
        }
    }

    private Object parseServer(Element subElement) {
        return this.parseConnection(subElement);
    }

    private Object parseLocator(Element subElement) {
        return this.parseConnection(subElement);
    }

    private BeanDefinition parseConnection(Element element) {
        BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.genericBeanDefinition(PoolConnection.class);
        ParsingUtils.setPropertyValue(element, defBuilder, "host", "host");
        ParsingUtils.setPropertyValue(element, defBuilder, "port", "port");
        return defBuilder.getBeanDefinition();
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = "gemfire-pool";
        }
        return name;
    }
}

