/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.listener.ContinuousQueryDefinition;
import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;
import org.springframework.data.gemfire.listener.adapter.ContinuousQueryListenerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GemfireListenerContainerParser
extends AbstractSimpleBeanDefinitionParser {
    GemfireListenerContainerParser() {
    }

    protected Class<ContinuousQueryListenerContainer> getBeanClass(Element element) {
        return ContinuousQueryListenerContainer.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            if (!this.isEligibleAttribute(attribute, parserContext)) continue;
            String propertyName = this.extractPropertyName(attribute.getLocalName());
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyReference(propertyName, attribute.getValue());
        }
        ParsingUtils.setPropertyValue(element, builder, "phase", "phase");
        ParsingUtils.setPropertyValue(element, builder, "pool-name", "poolName");
        this.postProcess(builder, element);
        List listDefs = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        if (!listDefs.isEmpty()) {
            ManagedSet listeners = new ManagedSet(listDefs.size());
            for (Element listElement : listDefs) {
                listeners.add((Object)this.parseListener(listElement));
            }
            builder.addPropertyValue("queryListeners", (Object)listeners);
        }
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !"phase".equals(attributeName);
    }

    private BeanDefinition parseListener(Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ContinuousQueryListenerAdapter.class);
        builder.addConstructorArgReference(element.getAttribute("ref"));
        String attr = element.getAttribute("method");
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue("defaultListenerMethod", (Object)attr);
        }
        BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.genericBeanDefinition(ContinuousQueryDefinition.class);
        attr = element.getAttribute("name");
        if (StringUtils.hasText((String)attr)) {
            defBuilder.addConstructorArgValue((Object)attr);
        }
        defBuilder.addConstructorArgValue((Object)element.getAttribute("query"));
        defBuilder.addConstructorArgValue((Object)builder.getBeanDefinition());
        attr = element.getAttribute("durable");
        if (StringUtils.hasText((String)attr)) {
            defBuilder.addConstructorArgValue((Object)attr);
        }
        return defBuilder.getBeanDefinition();
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

