/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements DisposableBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean destroy = false;
    private boolean close = true;
    private Resource snapshot;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private RegionAttributes<K, V> attributes;
    private Scope scope;
    private DataPolicy dataPolicy;
    private Region<K, V> region;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.region = this.getRegion();
        this.postProcess(this.region);
    }

    @Override
    protected Region<K, V> lookupFallback(GemFireCache cache, String regionName) throws Exception {
        RegionFactory regionFactory;
        Assert.isTrue((boolean)(cache instanceof Cache), (String)("Unable to create regions from " + cache));
        Cache c = (Cache)cache;
        if (this.attributes != null) {
            AttributesFactory.validateAttributes(this.attributes);
        }
        RegionFactory regionFactory2 = regionFactory = this.attributes != null ? c.createRegionFactory(this.attributes) : c.createRegionFactory();
        if (!ObjectUtils.isEmpty((Object[])this.cacheListeners)) {
            for (CacheListener<K, V> listener : this.cacheListeners) {
                regionFactory.addCacheListener(listener);
            }
        }
        if (this.cacheLoader != null) {
            regionFactory.setCacheLoader(this.cacheLoader);
        }
        if (this.cacheWriter != null) {
            regionFactory.setCacheWriter(this.cacheWriter);
        }
        if (this.dataPolicy != null) {
            regionFactory.setDataPolicy(this.dataPolicy);
        }
        if (this.scope != null) {
            regionFactory.setScope(this.scope);
        }
        this.postProcess(this.findAttrFactory(regionFactory));
        Region reg = regionFactory.create(regionName);
        this.log.info((Object)("Created new cache region [" + regionName + "]"));
        if (this.snapshot != null) {
            reg.loadSnapshot(this.snapshot.getInputStream());
        }
        return reg;
    }

    private AttributesFactory<K, V> findAttrFactory(RegionFactory<K, V> regionFactory) {
        Field attrField = ReflectionUtils.findField(RegionFactory.class, (String)"attrsFactory", AttributesFactory.class);
        ReflectionUtils.makeAccessible((Field)attrField);
        return (AttributesFactory)ReflectionUtils.getField((Field)attrField, regionFactory);
    }

    @Deprecated
    protected void postProcess(AttributesFactory<K, V> attrFactory) {
    }

    protected void postProcess(Region<K, V> region) {
    }

    public void destroy() throws Exception {
        if (this.region != null) {
            if (this.close) {
                if (!this.region.getCache().isClosed()) {
                    try {
                        this.region.close();
                    }
                    catch (CacheClosedException cacheClosedException) {}
                }
            } else if (this.destroy) {
                this.region.destroyRegion();
            }
        }
        this.region = null;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
        if (destroy) {
            this.close = false;
        }
    }

    public void setClose(boolean close) {
        this.close = close;
        if (close) {
            this.destroy = false;
        }
    }

    public void setSnapshot(Resource snapshot) {
        this.snapshot = snapshot;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }
}

