/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.Hibernate;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.DefaultRevisionEntity;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.order.AuditOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.envers.repository.support.DefaultRevisionMetadata;
import org.springframework.data.history.AnnotationRevisionMetadata;
import org.springframework.data.history.Revision;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.history.RevisionSort;
import org.springframework.data.history.Revisions;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.data.repository.history.support.RevisionEntityInformation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class EnversRevisionRepositoryImpl<T, ID, N extends Number>
implements RevisionRepository<T, ID, N> {
    private final EntityInformation<T, ?> entityInformation;
    private final EntityManager entityManager;

    public EnversRevisionRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, RevisionEntityInformation revisionEntityInformation, EntityManager entityManager) {
        Assert.notNull((Object)revisionEntityInformation, (String)"RevisionEntityInformation must not be null");
        this.entityInformation = entityInformation;
        this.entityManager = entityManager;
    }

    public Optional<Revision<N, T>> findLastChangeRevision(ID id) {
        List singleResult = this.createBaseQuery(id).addOrder(AuditEntity.revisionProperty((String)"timestamp").desc()).setMaxResults(1).getResultList();
        Assert.state((singleResult.size() <= 1 ? 1 : 0) != 0, (String)"We expect at most one result");
        if (singleResult.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.createRevision(new QueryResult((Object[])singleResult.get(0))));
    }

    public Optional<Revision<N, T>> findRevision(ID id, N revisionNumber) {
        Assert.notNull(id, (String)"Identifier must not be null");
        Assert.notNull(revisionNumber, (String)"Revision number must not be null");
        List singleResult = this.createBaseQuery(id).add(AuditEntity.revisionNumber().eq(revisionNumber)).getResultList();
        Assert.state((singleResult.size() <= 1 ? 1 : 0) != 0, (String)"We expect at most one result");
        if (singleResult.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.createRevision(new QueryResult((Object[])singleResult.get(0))));
    }

    public Revisions<N, T> findRevisions(ID id) {
        List resultList = this.createBaseQuery(id).getResultList();
        ArrayList revisionList = new ArrayList(resultList.size());
        for (Object[] objects : resultList) {
            revisionList.add(this.createRevision(new QueryResult(objects)));
        }
        return Revisions.of(revisionList);
    }

    public Page<Revision<N, T>> findRevisions(ID id, Pageable pageable) {
        AuditOrder sorting = RevisionSort.getRevisionDirection((Sort)pageable.getSort()).isDescending() ? AuditEntity.revisionNumber().desc() : AuditEntity.revisionNumber().asc();
        List resultList = this.createBaseQuery(id).addOrder(sorting).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        Long count = (Long)this.createBaseQuery(id).addProjection(AuditEntity.revisionNumber().count()).getSingleResult();
        ArrayList revisions = new ArrayList();
        for (Object[] singleResult : resultList) {
            revisions.add(this.createRevision(new QueryResult(singleResult)));
        }
        return new PageImpl(revisions, pageable, count.longValue());
    }

    private AuditQuery createBaseQuery(ID id) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        return reader.createQuery().forRevisionsOfEntity(type, false, true).add(AuditEntity.id().eq(id));
    }

    private Revision<N, T> createRevision(QueryResult<T> queryResult) {
        return Revision.of(queryResult.createRevisionMetadata(), queryResult.entity);
    }

    static class QueryResult<T> {
        private final T entity;
        private final Object metadata;
        private final RevisionMetadata.RevisionType revisionType;

        QueryResult(Object[] data) {
            Assert.notNull((Object)data, (String)"Data must not be null");
            Assert.isTrue((data.length == 3 ? 1 : 0) != 0, () -> String.format("Data must have length three, but has length %d", data.length));
            Assert.isTrue((boolean)(data[2] instanceof RevisionType), () -> String.format("The third array element must be of type Revision type, but is of type %s", data[2].getClass()));
            this.entity = data[0];
            this.metadata = data[1];
            this.revisionType = QueryResult.convertRevisionType((RevisionType)data[2]);
        }

        RevisionMetadata<?> createRevisionMetadata() {
            return this.metadata instanceof DefaultRevisionEntity ? new DefaultRevisionMetadata((DefaultRevisionEntity)this.metadata, this.revisionType) : new AnnotationRevisionMetadata(Hibernate.unproxy((Object)this.metadata), RevisionNumber.class, RevisionTimestamp.class, this.revisionType);
        }

        private static RevisionMetadata.RevisionType convertRevisionType(RevisionType datum) {
            switch (datum) {
                case ADD: {
                    return RevisionMetadata.RevisionType.INSERT;
                }
                case MOD: {
                    return RevisionMetadata.RevisionType.UPDATE;
                }
                case DEL: {
                    return RevisionMetadata.RevisionType.DELETE;
                }
            }
            return RevisionMetadata.RevisionType.UNKNOWN;
        }
    }
}

