/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;
import lombok.NonNull;
import org.hibernate.envers.DefaultRevisionEntity;
import org.springframework.data.history.RevisionMetadata;

public final class DefaultRevisionMetadata
implements RevisionMetadata<Integer> {
    @NonNull
    private final DefaultRevisionEntity entity;

    public Optional<Integer> getRevisionNumber() {
        return Optional.ofNullable(this.entity.getId());
    }

    public Optional<LocalDateTime> getRevisionDate() {
        return Optional.of(LocalDateTime.from(Instant.ofEpochMilli(this.entity.getTimestamp())));
    }

    public <T> T getDelegate() {
        return (T)this.entity;
    }

    @ConstructorProperties(value={"entity"})
    public DefaultRevisionMetadata(@NonNull DefaultRevisionEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        this.entity = entity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRevisionMetadata)) {
            return false;
        }
        DefaultRevisionMetadata other = (DefaultRevisionMetadata)o;
        DefaultRevisionEntity this$entity = this.entity;
        DefaultRevisionEntity other$entity = other.entity;
        return !(this$entity == null ? other$entity != null : !this$entity.equals(other$entity));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultRevisionEntity $entity = this.entity;
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultRevisionMetadata(entity=" + this.entity + ")";
    }
}

