/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.Collection;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableRemoveByIdOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByIdOperationSupport;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.util.Assert;

public class ExecutableRemoveByIdOperationSupport
implements ExecutableRemoveByIdOperation {
    private final CouchbaseTemplate template;

    public ExecutableRemoveByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    @Deprecated
    public ExecutableRemoveByIdOperation.ExecutableRemoveById removeById() {
        return this.removeById(null);
    }

    @Override
    public ExecutableRemoveByIdOperation.ExecutableRemoveById removeById(Class<?> domainType) {
        return new ExecutableRemoveByIdSupport(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, OptionsBuilder.getPersistTo(domainType), OptionsBuilder.getReplicateTo(domainType), OptionsBuilder.getDurabilityLevel(domainType, this.template.getConverter()), null);
    }

    static class ExecutableRemoveByIdSupport
    implements ExecutableRemoveByIdOperation.ExecutableRemoveById {
        private final CouchbaseTemplate template;
        private final Class<?> domainType;
        private final String scope;
        private final String collection;
        private final RemoveOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Long cas;
        private final ReactiveRemoveByIdOperationSupport.ReactiveRemoveByIdSupport reactiveRemoveByIdSupport;

        ExecutableRemoveByIdSupport(CouchbaseTemplate template, Class<?> domainType, String scope, String collection, RemoveOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Long cas) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.reactiveRemoveByIdSupport = new ReactiveRemoveByIdOperationSupport.ReactiveRemoveByIdSupport(template.reactive(), domainType, scope, collection, options, persistTo, replicateTo, durabilityLevel, cas);
            this.cas = cas;
        }

        @Override
        public RemoveResult one(String id) {
            return (RemoveResult)this.reactiveRemoveByIdSupport.one(id).block();
        }

        @Override
        public RemoveResult oneEntity(Object entity) {
            return (RemoveResult)this.reactiveRemoveByIdSupport.oneEntity(entity).block();
        }

        @Override
        public List<RemoveResult> all(Collection<String> ids) {
            return (List)this.reactiveRemoveByIdSupport.all(ids).collectList().block();
        }

        @Override
        public List<RemoveResult> allEntities(Collection<Object> entities) {
            return (List)this.reactiveRemoveByIdSupport.allEntities(entities).collectList().block();
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdWithOptions inCollection(String collection) {
            return new ExecutableRemoveByIdSupport(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdInScope withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ExecutableRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdInScope withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ExecutableRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.TerminatingRemoveById withOptions(RemoveOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdInCollection inScope(String scope) {
            return new ExecutableRemoveByIdSupport(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdWithDurability withCas(Long cas) {
            return new ExecutableRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, cas);
        }
    }
}

