/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.config.RepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.support.CouchbaseRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.util.Assert;

public class CouchbaseRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<CouchbaseOperations> couchbaseOperationsBean;

    public CouchbaseRepositoryBean(Bean<CouchbaseOperations> operations, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, CustomRepositoryImplementationDetector detector) {
        super(qualifiers, repositoryType, beanManager, Optional.of(detector));
        Assert.notNull(operations, (String)"Cannot create repository with 'null' for CouchbaseOperations.");
        this.couchbaseOperationsBean = operations;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        CouchbaseOperations couchbaseOperations = (CouchbaseOperations)this.getDependencyInstance(this.couchbaseOperationsBean, CouchbaseOperations.class);
        RepositoryOperationsMapping couchbaseOperationsMapping = new RepositoryOperationsMapping(couchbaseOperations);
        return (T)this.create(() -> new CouchbaseRepositoryFactory(couchbaseOperationsMapping), repositoryType);
    }

    public Class<? extends Annotation> getScope() {
        return this.couchbaseOperationsBean.getScope();
    }
}

