/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryScanConsistency;
import com.couchbase.client.core.classic.query.ClassicCoreQueryOps;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutationState;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.kv.ScanOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.couchbase.core.query.Meta;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.Collection;
import org.springframework.data.couchbase.repository.ScanConsistency;
import org.springframework.data.couchbase.repository.Scope;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;

public class OptionsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OptionsBuilder.class);

    static QueryOptions buildQueryOptions(Query query, QueryOptions options, QueryScanConsistency scanConsistency) {
        QueryOptions queryOptions = options = options != null ? options : QueryOptions.queryOptions();
        if (query.getParameters() != null) {
            if (query.getParameters() instanceof JsonArray && !((JsonArray)query.getParameters()).isEmpty()) {
                options.parameters((JsonArray)query.getParameters());
            } else if (query.getParameters() instanceof JsonObject && !((JsonObject)query.getParameters()).isEmpty()) {
                options.parameters((JsonObject)query.getParameters());
            }
        }
        Meta meta = query.getMeta() != null ? query.getMeta() : new Meta();
        QueryOptions.Built optsBuilt = options.build();
        QueryScanConsistency metaQueryScanConsistency = meta.get(Meta.MetaKey.SCAN_CONSISTENCY) != null ? ((ScanConsistency)meta.get(Meta.MetaKey.SCAN_CONSISTENCY)).query() : null;
        QueryScanConsistency qsc = OptionsBuilder.fromFirst(QueryScanConsistency.NOT_BOUNDED, query.getScanConsistency(), OptionsBuilder.scanConsistency(optsBuilt), scanConsistency, metaQueryScanConsistency);
        Duration timeout = OptionsBuilder.fromFirst(Duration.ofSeconds(0L), OptionsBuilder.getTimeout(optsBuilt), meta.get(Meta.MetaKey.TIMEOUT));
        RetryStrategy retryStrategy = OptionsBuilder.fromFirst(null, OptionsBuilder.getRetryStrategy(optsBuilt), meta.get(Meta.MetaKey.RETRY_STRATEGY));
        if (qsc != null) {
            options.scanConsistency(qsc);
        }
        if (timeout != null) {
            options.timeout(timeout);
        }
        if (retryStrategy != null) {
            options.retryStrategy(retryStrategy);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("query options: {}", (Object)OptionsBuilder.getQueryOpts(options.build()));
        }
        return options;
    }

    private static QueryScanConsistency scanConsistency(QueryOptions.Built optsBuilt) {
        CoreQueryScanConsistency scanConsistency = optsBuilt.scanConsistency();
        if (scanConsistency == null) {
            return null;
        }
        switch (scanConsistency) {
            case NOT_BOUNDED: {
                return QueryScanConsistency.NOT_BOUNDED;
            }
            case REQUEST_PLUS: {
                return QueryScanConsistency.REQUEST_PLUS;
            }
        }
        throw new InvalidArgumentException("Unknown scan consistency type " + scanConsistency, null, null);
    }

    public static TransactionQueryOptions buildTransactionQueryOptions(QueryOptions options) {
        QueryOptions.Built built = options.build();
        TransactionQueryOptions txOptions = TransactionQueryOptions.queryOptions();
        JsonObject optsJson = OptionsBuilder.getQueryOpts(built);
        if (optsJson.containsKey("use_fts")) {
            throw new IllegalArgumentException("QueryOptions.flexIndex is not supported in a transaction");
        }
        Object value = optsJson.get("args");
        if (value instanceof JsonObject) {
            txOptions.parameters((JsonObject)value);
        } else if (value instanceof JsonArray) {
            txOptions.parameters((JsonArray)value);
        } else if (value != null) {
            throw InvalidArgumentException.fromMessage((String)("non-null args property was neither JsonObject(namedParameters) nor JsonArray(positionalParameters) " + value));
        }
        for (Map.Entry entry : optsJson.toMap().entrySet()) {
            if (((String)entry.getKey()).equals("args")) continue;
            txOptions.raw((String)entry.getKey(), entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("query options: {}", (Object)optsJson);
        }
        return txOptions;
    }

    public static ExistsOptions buildExistsOptions(ExistsOptions options) {
        options = options != null ? options : ExistsOptions.existsOptions();
        return options;
    }

    public static InsertOptions buildInsertOptions(InsertOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, CouchbaseDocument doc) {
        InsertOptions insertOptions = options = options != null ? options : InsertOptions.insertOptions();
        if (persistTo != PersistTo.NONE || replicateTo != ReplicateTo.NONE) {
            options.durability(persistTo, replicateTo);
        } else if (durabilityLevel != DurabilityLevel.NONE) {
            options.durability(durabilityLevel);
        }
        if (expiry != null) {
            options.expiry(expiry);
        } else if (doc.getExpiration() != 0) {
            options.expiry(Duration.ofSeconds(doc.getExpiration()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("insert options: {}" + OptionsBuilder.toString(options));
        }
        return options;
    }

    public static UpsertOptions buildUpsertOptions(UpsertOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, CouchbaseDocument doc) {
        UpsertOptions upsertOptions = options = options != null ? options : UpsertOptions.upsertOptions();
        if (persistTo != PersistTo.NONE || replicateTo != ReplicateTo.NONE) {
            options.durability(persistTo, replicateTo);
        } else if (durabilityLevel != DurabilityLevel.NONE) {
            options.durability(durabilityLevel);
        }
        if (expiry != null) {
            options.expiry(expiry);
        } else if (doc.getExpiration() != 0) {
            options.expiry(Duration.ofSeconds(doc.getExpiration()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("upsert options: {}" + OptionsBuilder.toString(options));
        }
        return options;
    }

    public static MutateInOptions buildMutateInOptions(MutateInOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, CouchbaseDocument doc, Long cas) {
        MutateInOptions mutateInOptions = options = options != null ? options : MutateInOptions.mutateInOptions();
        if (persistTo != PersistTo.NONE || replicateTo != ReplicateTo.NONE) {
            options.durability(persistTo, replicateTo);
        } else if (durabilityLevel != DurabilityLevel.NONE) {
            options.durability(durabilityLevel);
        }
        if (expiry != null) {
            options.expiry(expiry);
        } else if (doc.getExpiration() != 0) {
            options.expiry(Duration.ofSeconds(doc.getExpiration()));
        }
        if (cas != null) {
            options.cas(cas.longValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("mutate in options: {}" + OptionsBuilder.toString(options));
        }
        return options;
    }

    public static ReplaceOptions buildReplaceOptions(ReplaceOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, Long cas, CouchbaseDocument doc) {
        ReplaceOptions replaceOptions = options = options != null ? options : ReplaceOptions.replaceOptions();
        if (persistTo != PersistTo.NONE || replicateTo != ReplicateTo.NONE) {
            options.durability(persistTo, replicateTo);
        } else if (durabilityLevel != DurabilityLevel.NONE) {
            options.durability(durabilityLevel);
        }
        if (expiry != null) {
            options.expiry(expiry);
        } else if (doc.getExpiration() != 0) {
            options.expiry(Duration.ofSeconds(doc.getExpiration()));
        }
        if (cas != null) {
            options.cas(cas.longValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("replace options: {}" + OptionsBuilder.toString(options));
        }
        return options;
    }

    public static RemoveOptions buildRemoveOptions(RemoveOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Long cas) {
        RemoveOptions removeOptions = options = options != null ? options : RemoveOptions.removeOptions();
        if (persistTo != PersistTo.NONE || replicateTo != ReplicateTo.NONE) {
            options.durability(persistTo, replicateTo);
        } else if (durabilityLevel != DurabilityLevel.NONE) {
            options.durability(durabilityLevel);
        }
        RemoveOptions.Built optsBuilt = options.build();
        Duration timeout = OptionsBuilder.fromFirst(Duration.ofSeconds(0L), optsBuilt.timeout());
        RetryStrategy retryStrategy = OptionsBuilder.fromFirst(null, optsBuilt.retryStrategy());
        if (timeout != null) {
            options.timeout(timeout);
        }
        if (retryStrategy != null) {
            options.retryStrategy(retryStrategy);
        }
        if (cas != null) {
            options.cas(cas.longValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove options: {}", (Object)OptionsBuilder.toString(options));
        }
        return options;
    }

    public static String getScopeFrom(Class<?> domainType) {
        if (domainType == null) {
            return null;
        }
        Scope ann = (Scope)AnnotatedElementUtils.findMergedAnnotation(domainType, Scope.class);
        if (ann != null && !"_default".equals(ann.value())) {
            return ann.value();
        }
        return null;
    }

    public static DurabilityLevel getDurabilityLevel(Class<?> domainType, CouchbaseConverter converter) {
        if (domainType == null) {
            return DurabilityLevel.NONE;
        }
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(domainType);
        return entity.getDurabilityLevel();
    }

    public static PersistTo getPersistTo(Class<?> domainType) {
        if (domainType == null) {
            return PersistTo.NONE;
        }
        Document document = (Document)AnnotatedElementUtils.findMergedAnnotation(domainType, Document.class);
        return document != null ? document.persistTo() : PersistTo.NONE;
    }

    public static ReplicateTo getReplicateTo(Class<?> domainType) {
        if (domainType == null) {
            return ReplicateTo.NONE;
        }
        Document document = (Document)AnnotatedElementUtils.findMergedAnnotation(domainType, Document.class);
        return document != null ? document.replicateTo() : ReplicateTo.NONE;
    }

    public static String getCollectionFrom(Class<?> domainType) {
        if (domainType == null) {
            return null;
        }
        Collection ann = (Collection)AnnotatedElementUtils.findMergedAnnotation(domainType, Collection.class);
        if (ann != null && !"_default".equals(ann.value())) {
            return ann.value();
        }
        return null;
    }

    static String toString(InsertOptions o) {
        StringBuilder s = new StringBuilder();
        InsertOptions.Built b = o.build();
        s.append("{");
        s.append("durabilityLevel: " + b.durabilityLevel());
        s.append(", persistTo: " + b.persistTo());
        s.append(", replicateTo: " + b.replicateTo());
        s.append(", timeout: " + b.timeout());
        s.append(", retryStrategy: " + b.retryStrategy());
        s.append(", clientContext: " + b.clientContext());
        s.append(", parentSpan: " + b.parentSpan());
        s.append("}");
        return s.toString();
    }

    static String toString(UpsertOptions o) {
        StringBuilder s = new StringBuilder();
        UpsertOptions.Built b = o.build();
        s.append("{");
        s.append("durabilityLevel: " + b.durabilityLevel());
        s.append(", persistTo: " + b.persistTo());
        s.append(", replicateTo: " + b.replicateTo());
        s.append(", timeout: " + b.timeout());
        s.append(", retryStrategy: " + b.retryStrategy());
        s.append(", clientContext: " + b.clientContext());
        s.append(", parentSpan: " + b.parentSpan());
        s.append("}");
        return s.toString();
    }

    static String toString(ReplaceOptions o) {
        StringBuilder s = new StringBuilder();
        ReplaceOptions.Built b = o.build();
        s.append("{");
        s.append("cas: " + b.cas());
        s.append(", durabilityLevel: " + b.durabilityLevel());
        s.append(", persistTo: " + b.persistTo());
        s.append(", replicateTo: " + b.replicateTo());
        s.append(", timeout: " + b.timeout());
        s.append(", retryStrategy: " + b.retryStrategy());
        s.append(", clientContext: " + b.clientContext());
        s.append(", parentSpan: " + b.parentSpan());
        s.append("}");
        return s.toString();
    }

    static String toString(RemoveOptions o) {
        StringBuilder s = new StringBuilder();
        RemoveOptions.Built b = o.build();
        s.append("{");
        s.append("cas: " + b.cas());
        s.append(", durabilityLevel: " + b.durabilityLevel());
        s.append(", persistTo: " + b.persistTo());
        s.append(", replicateTo: " + b.replicateTo());
        s.append(", timeout: " + b.timeout());
        s.append(", retryStrategy: " + b.retryStrategy());
        s.append(", clientContext: " + b.clientContext());
        s.append(", parentSpan: " + b.parentSpan());
        s.append("}");
        return s.toString();
    }

    static String toString(MutateInOptions o) {
        StringBuilder s = new StringBuilder();
        MutateInOptions.Built b = o.build();
        s.append("{");
        s.append("cas: " + b.cas());
        s.append(", durabilityLevel: " + b.durabilityLevel());
        s.append(", persistTo: " + b.persistTo());
        s.append(", replicateTo: " + b.replicateTo());
        s.append(", timeout: " + b.timeout());
        s.append(", retryStrategy: " + b.retryStrategy());
        s.append(", clientContext: " + b.clientContext());
        s.append(", parentSpan: " + b.parentSpan());
        s.append("}");
        return s.toString();
    }

    public static JsonObject getQueryOpts(QueryOptions.Built optsBuilt) {
        return JsonObject.fromJson((byte[])ClassicCoreQueryOps.convertOptions((CoreQueryOptions)optsBuilt).toString().getBytes());
    }

    public static <T> T fromFirst(T deflt, Object ... choice) {
        Object chosen = choice[0] instanceof Optional ? ((Optional)choice[0]).orElse(null) : choice[0];
        for (int i = 1; i < choice.length; ++i) {
            if (chosen != null && !chosen.equals(deflt) || choice[i] == null) continue;
            chosen = choice[i] instanceof Optional ? ((Optional)choice[i]).orElse(null) : choice[i];
        }
        return (T)chosen;
    }

    private static Duration getTimeout(QueryOptions.Built optsBuilt) {
        Optional timeout = optsBuilt.timeout();
        return timeout.isPresent() ? (Duration)timeout.get() : null;
    }

    private static RetryStrategy getRetryStrategy(QueryOptions.Built optsBuilt) {
        Optional retryStrategy = optsBuilt.retryStrategy();
        return retryStrategy.isPresent() ? (RetryStrategy)retryStrategy.get() : null;
    }

    public static Meta buildMeta(CouchbaseQueryMethod method, Class<?> typeToRead) {
        Meta meta = new Meta();
        meta.set(Meta.MetaKey.SCAN_CONSISTENCY, method.getScanConsistencyAnnotation());
        return meta;
    }

    public static <A extends Annotation, V> A annotation(Class<A> annotation, String attributeName, V defaultValue, AnnotatedElement ... elements) {
        boolean i = true;
        for (AnnotatedElement el : elements) {
            Annotation an = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)el, annotation);
            if (an == null) continue;
            if (defaultValue != null) {
                try {
                    Method m = an.getClass().getMethod(attributeName, new Class[0]);
                    Object value = m.invoke((Object)an, new Object[0]);
                    if (defaultValue.equals(value)) continue;
                    return (A)an;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return (A)an;
        }
        return null;
    }

    public static <A extends Annotation, V> A annotation(Class<A> annotation, V defaultValue, AnnotatedElement[] elements) {
        return OptionsBuilder.annotation(annotation, "value", defaultValue, elements);
    }

    public static <A extends Annotation, V> V annotationAttribute(Class<A> annotation, String attributeName, V defaultValue, AnnotatedElement[] elements) {
        for (AnnotatedElement el : elements) {
            Annotation an = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)el, annotation);
            if (an == null) continue;
            try {
                Method m = an.getClass().getMethod(attributeName, new Class[0]);
                Object result = m.invoke((Object)an, new Object[0]);
                if (result == null || result.equals(defaultValue)) continue;
                return (V)result;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static <A extends Annotation> String annotationString(Class<A> annotation, String attributeName, Object defaultValue, AnnotatedElement[] elements) {
        A result = OptionsBuilder.annotation(annotation, defaultValue, elements);
        if (result == null) {
            return null;
        }
        try {
            Method m = result.getClass().getMethod(attributeName, new Class[0]);
            Object value = m.invoke(result, new Object[0]);
            return value.toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <A extends Annotation> String annotationString(Class<A> annotation, Object defaultValue, AnnotatedElement[] elements) {
        return OptionsBuilder.annotationString(annotation, "value", defaultValue, elements);
    }

    public static ScanOptions buildScanOptions(ScanOptions options, Object sort, Boolean idsOnly, MutationState mutationState, Integer batchByteLimit, Integer batchItemLimit) {
        ScanOptions scanOptions = options = options != null ? options : ScanOptions.scanOptions();
        if (sort != null) {
            // empty if block
        }
        if (idsOnly != null) {
            options.idsOnly(idsOnly.booleanValue());
        }
        if (mutationState != null) {
            options.consistentWith(mutationState);
        }
        if (batchByteLimit != null) {
            options.batchByteLimit(batchByteLimit.intValue());
        }
        if (batchItemLimit != null) {
            options.batchItemLimit(batchItemLimit.intValue());
        }
        return options;
    }

    public static CoreQueryContext queryContext(String scope, String collection, String bucketName) {
        return !(scope != null && !"_default".equals(scope) || collection != null && !"_default".equals(collection)) ? null : CoreQueryContext.of((String)bucketName, (String)scope);
    }
}

