/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.codec.JacksonJsonSerializer;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.encryption.annotation.Encrypted;
import com.couchbase.client.java.encryption.databind.jackson.EncryptionModule;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonValueModule;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.PropertyValueConverterRegistrar;
import org.springframework.data.convert.SimplePropertyValueConversions;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.SimpleCouchbaseClientFactory;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.convert.BooleanToEnumConverterFactory;
import org.springframework.data.couchbase.core.convert.CouchbaseCustomConversions;
import org.springframework.data.couchbase.core.convert.CouchbasePropertyValueConverterFactory;
import org.springframework.data.couchbase.core.convert.CryptoConverter;
import org.springframework.data.couchbase.core.convert.IntegerToEnumConverterFactory;
import org.springframework.data.couchbase.core.convert.JsonValueConverter;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.OtherConverters;
import org.springframework.data.couchbase.core.convert.StringToEnumConverterFactory;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.couchbase.repository.config.ReactiveRepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.config.RepositoryOperationsMapping;
import org.springframework.data.couchbase.transaction.CouchbaseCallbackTransactionManager;
import org.springframework.data.couchbase.transaction.CouchbaseTransactionInterceptor;
import org.springframework.data.couchbase.transaction.CouchbaseTransactionalOperator;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.CamelCaseAbbreviatingFieldNamingStrategy;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractCouchbaseConfiguration {
    volatile ObjectMapper objectMapper;
    volatile CryptoManager cryptoManager = null;

    public abstract String getConnectionString();

    public abstract String getUserName();

    public abstract String getPassword();

    public abstract String getBucketName();

    protected String getScopeName() {
        return null;
    }

    protected Authenticator authenticator() {
        return PasswordAuthenticator.create((String)this.getUserName(), (String)this.getPassword());
    }

    @Bean(name={"couchbaseClientFactory"})
    public CouchbaseClientFactory couchbaseClientFactory(Cluster couchbaseCluster) {
        return new SimpleCouchbaseClientFactory(couchbaseCluster, this.getBucketName(), this.getScopeName());
    }

    @Bean(destroyMethod="disconnect")
    public Cluster couchbaseCluster(ClusterEnvironment couchbaseClusterEnvironment) {
        return Cluster.connect((String)this.getConnectionString(), (ClusterOptions)ClusterOptions.clusterOptions((Authenticator)this.authenticator()).environment(couchbaseClusterEnvironment));
    }

    @Bean(destroyMethod="shutdown")
    public ClusterEnvironment couchbaseClusterEnvironment() {
        ClusterEnvironment.Builder builder = ClusterEnvironment.builder();
        if (!this.nonShadowedJacksonPresent()) {
            throw new CouchbaseException("non-shadowed Jackson not present");
        }
        builder.jsonSerializer((JsonSerializer)JacksonJsonSerializer.create((ObjectMapper)this.getObjectMapper()));
        builder.cryptoManager(this.getCryptoManager());
        this.configureEnvironment(builder);
        return builder.build();
    }

    protected void configureEnvironment(ClusterEnvironment.Builder builder) {
    }

    @Bean(name={"couchbaseTemplate"})
    public CouchbaseTemplate couchbaseTemplate(CouchbaseClientFactory couchbaseClientFactory, MappingCouchbaseConverter mappingCouchbaseConverter, TranslationService couchbaseTranslationService) {
        return new CouchbaseTemplate(couchbaseClientFactory, mappingCouchbaseConverter, couchbaseTranslationService, this.getDefaultConsistency());
    }

    @Bean(name={"reactiveCouchbaseTemplate"})
    public ReactiveCouchbaseTemplate reactiveCouchbaseTemplate(CouchbaseClientFactory couchbaseClientFactory, MappingCouchbaseConverter mappingCouchbaseConverter, TranslationService couchbaseTranslationService) {
        return new ReactiveCouchbaseTemplate(couchbaseClientFactory, mappingCouchbaseConverter, couchbaseTranslationService, this.getDefaultConsistency());
    }

    @Bean(name={"couchbaseRepositoryOperationsMapping"})
    public RepositoryOperationsMapping couchbaseRepositoryOperationsMapping(CouchbaseTemplate couchbaseTemplate) {
        RepositoryOperationsMapping baseMapping = new RepositoryOperationsMapping(couchbaseTemplate);
        this.configureRepositoryOperationsMapping(baseMapping);
        return baseMapping;
    }

    protected void configureRepositoryOperationsMapping(RepositoryOperationsMapping mapping) {
    }

    @Bean(name={"reactiveCouchbaseRepositoryOperationsMapping"})
    public ReactiveRepositoryOperationsMapping reactiveCouchbaseRepositoryOperationsMapping(ReactiveCouchbaseTemplate reactiveCouchbaseTemplate) {
        ReactiveRepositoryOperationsMapping baseMapping = new ReactiveRepositoryOperationsMapping(reactiveCouchbaseTemplate);
        this.configureReactiveRepositoryOperationsMapping(baseMapping);
        return baseMapping;
    }

    protected void configureReactiveRepositoryOperationsMapping(ReactiveRepositoryOperationsMapping mapping) {
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        String basePackage = this.getMappingBasePackage();
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)AbstractCouchbaseConfiguration.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }

    public String typeKey() {
        return "_class";
    }

    @Bean
    public MappingCouchbaseConverter mappingCouchbaseConverter(CouchbaseMappingContext couchbaseMappingContext, CouchbaseCustomConversions couchbaseCustomConversions) {
        MappingCouchbaseConverter converter = new MappingCouchbaseConverter((MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty>)couchbaseMappingContext, this.typeKey());
        converter.setCustomConversions(couchbaseCustomConversions);
        couchbaseMappingContext.setSimpleTypeHolder(couchbaseCustomConversions.getSimpleTypeHolder());
        return converter;
    }

    @Bean
    public TranslationService couchbaseTranslationService() {
        JacksonTranslationService jacksonTranslationService = new JacksonTranslationService();
        jacksonTranslationService.setObjectMapper(this.getObjectMapper());
        jacksonTranslationService.afterPropertiesSet();
        JacksonTransformers.MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return jacksonTranslationService;
    }

    @Bean(value={"couchbaseMappingContext"})
    public CouchbaseMappingContext couchbaseMappingContext(CustomConversions customConversions) throws Exception {
        CouchbaseMappingContext mappingContext = new CouchbaseMappingContext();
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        mappingContext.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        mappingContext.setFieldNamingStrategy(this.fieldNamingStrategy());
        mappingContext.setAutoIndexCreation(this.autoIndexCreation());
        return mappingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            AbstractCouchbaseConfiguration abstractCouchbaseConfiguration = this;
            synchronized (abstractCouchbaseConfiguration) {
                if (this.objectMapper == null) {
                    this.objectMapper = this.couchbaseObjectMapper();
                }
            }
        }
        return this.objectMapper;
    }

    protected ObjectMapper couchbaseObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.configure(com.fasterxml.jackson.databind.DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.registerModule((Module)new JsonValueModule());
        if (this.getCryptoManager() != null) {
            om.registerModule((Module)new EncryptionModule(this.getCryptoManager()));
        }
        return om;
    }

    @Bean(value={"couchbaseTransactionManager"})
    CouchbaseCallbackTransactionManager couchbaseTransactionManager(CouchbaseClientFactory clientFactory) {
        return new CouchbaseCallbackTransactionManager(clientFactory);
    }

    @Bean(value={"couchbaseTransactionTemplate"})
    TransactionTemplate couchbaseTransactionTemplate(CouchbaseCallbackTransactionManager couchbaseTransactionManager) {
        return new TransactionTemplate((PlatformTransactionManager)couchbaseTransactionManager);
    }

    @Bean(value={"couchbaseTransactionalOperator"})
    public CouchbaseTransactionalOperator couchbaseTransactionalOperator(CouchbaseCallbackTransactionManager couchbaseCallbackTransactionManager) {
        return CouchbaseTransactionalOperator.create(couchbaseCallbackTransactionManager);
    }

    @Bean
    @Role(value=2)
    static BeanPostProcessor transactionInterceptorCustomizer(final ObjectProvider<TransactionManager> transactionManagerProvider, ConfigurableListableBeanFactory beanFactory) {
        BeanPostProcessor processor = new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof TransactionInterceptor) {
                    AnnotationTransactionAttributeSource transactionAttributeSource = new AnnotationTransactionAttributeSource();
                    TransactionManager transactionManager = (TransactionManager)transactionManagerProvider.getObject();
                    CouchbaseTransactionInterceptor interceptor = new CouchbaseTransactionInterceptor(transactionManager, (TransactionAttributeSource)transactionAttributeSource);
                    interceptor.setTransactionAttributeSource((TransactionAttributeSource)transactionAttributeSource);
                    if (transactionManager != null) {
                        interceptor.setTransactionManager(transactionManager);
                    }
                    return interceptor;
                }
                return bean;
            }
        };
        beanFactory.addBeanPostProcessor(processor);
        return processor;
    }

    protected boolean autoIndexCreation() {
        return false;
    }

    @Bean(name={"couchbaseCustomConversions"})
    public CustomConversions customConversions() {
        return this.customConversions(this.getCryptoManager(), this.getObjectMapper());
    }

    public CustomConversions customConversions(CryptoManager cryptoManager, ObjectMapper objectMapper) {
        ArrayList<Object> newConverters = new ArrayList<Object>();
        newConverters.add(new OtherConverters.EnumToObject(this.getObjectMapper()));
        newConverters.add(new IntegerToEnumConverterFactory(this.getObjectMapper()));
        newConverters.add(new StringToEnumConverterFactory(this.getObjectMapper()));
        newConverters.add(new BooleanToEnumConverterFactory(this.getObjectMapper()));
        CouchbaseCustomConversions customConversions = CouchbaseCustomConversions.create(configurationAdapter -> {
            SimplePropertyValueConversions valueConversions = new SimplePropertyValueConversions();
            valueConversions.setConverterFactory((PropertyValueConverterFactory)new CouchbasePropertyValueConverterFactory(cryptoManager, AbstractCouchbaseConfiguration.annotationToConverterMap(), objectMapper));
            valueConversions.setValueConverterRegistry(new PropertyValueConverterRegistrar().buildRegistry());
            valueConversions.afterPropertiesSet();
            configurationAdapter.setPropertyValueConversions((PropertyValueConversions)valueConversions);
            configurationAdapter.registerConverters(newConverters);
        });
        return customConversions;
    }

    public static Map<Class<? extends Annotation>, Class<?>> annotationToConverterMap() {
        HashMap map = new HashMap();
        map.put(Encrypted.class, CryptoConverter.class);
        map.put(JsonValue.class, JsonValueConverter.class);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CryptoManager getCryptoManager() {
        if (this.cryptoManager == null) {
            AbstractCouchbaseConfiguration abstractCouchbaseConfiguration = this;
            synchronized (abstractCouchbaseConfiguration) {
                if (this.cryptoManager == null) {
                    this.cryptoManager = this.cryptoManager();
                }
            }
        }
        return this.cryptoManager;
    }

    protected CryptoManager cryptoManager() {
        return null;
    }

    protected String getMappingBasePackage() {
        return this.getClass().getPackage().getName();
    }

    protected boolean abbreviateFieldNames() {
        return false;
    }

    protected FieldNamingStrategy fieldNamingStrategy() {
        return this.abbreviateFieldNames() ? new CamelCaseAbbreviatingFieldNamingStrategy() : PropertyNameFieldNamingStrategy.INSTANCE;
    }

    private boolean nonShadowedJacksonPresent() {
        try {
            JacksonJsonSerializer.preflightCheck();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public QueryScanConsistency getDefaultConsistency() {
        return null;
    }
}

