/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import java.lang.reflect.AnnotatedElement;
import java.time.Duration;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.data.annotation.Id;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.couchbase.core.mapping.Expiry;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicCouchbasePersistentEntity<T>
extends BasicPersistentEntity<T, CouchbasePersistentProperty>
implements CouchbasePersistentEntity<T>,
EnvironmentAware {
    private Environment environment;

    public BasicCouchbasePersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        this.validateExpirationConfiguration();
    }

    private void validateExpirationConfiguration() {
        Document annotation = this.getType().getAnnotation(Document.class);
        if (annotation != null && annotation.expiry() > 0 && StringUtils.hasLength((String)annotation.expiryExpression())) {
            String msg = String.format("Incorrect expiry configuration on class %s using %s. You cannot use 'expiry' and 'expiryExpression' at the same time", this.getType().getName(), annotation);
            throw new IllegalArgumentException(msg);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected CouchbasePersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(CouchbasePersistentProperty property) {
        if (!property.isIdProperty()) {
            return null;
        }
        if (!this.hasIdProperty()) {
            return property;
        }
        boolean currentSpringId = ((CouchbasePersistentProperty)this.getIdProperty()).isAnnotationPresent(Id.class);
        boolean candidateSpringId = property.isAnnotationPresent(Id.class);
        if (candidateSpringId && !currentSpringId) {
            return property;
        }
        if (currentSpringId && !candidateSpringId) {
            return null;
        }
        throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), ((CouchbasePersistentProperty)this.getIdProperty()).getField()));
    }

    @Override
    @Deprecated
    public int getExpiry() {
        return BasicCouchbasePersistentEntity.getExpiry((Expiry)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.getType(), Expiry.class), this.environment);
    }

    @Deprecated
    public static int getExpiry(Expiry annotation, Environment environment) {
        if (annotation == null) {
            return 0;
        }
        int expiryValue = BasicCouchbasePersistentEntity.getExpiryValue(annotation, environment);
        long secondsShift = annotation.expiryUnit().toSeconds(expiryValue);
        if (secondsShift > 2592000L) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (annotation.expiryUnit() == TimeUnit.DAYS) {
                cal.add(5, expiryValue);
            } else {
                cal.add(13, (int)secondsShift);
            }
            return (int)(cal.getTimeInMillis() / 1000L);
        }
        return (int)secondsShift;
    }

    @Override
    public Duration getExpiryDuration() {
        return BasicCouchbasePersistentEntity.getExpiryDuration((Expiry)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.getType(), Expiry.class), this.environment);
    }

    private static Duration getExpiryDuration(Expiry annotation, Environment environment) {
        if (annotation == null) {
            return Duration.ZERO;
        }
        int expiryValue = BasicCouchbasePersistentEntity.getExpiryValue(annotation, environment);
        long secondsShift = annotation.expiryUnit().toSeconds(expiryValue);
        return Duration.ofSeconds(secondsShift);
    }

    private static int getExpiryValue(Expiry annotation, Environment environment) {
        int expiryValue = annotation.expiry();
        String expiryExpressionString = annotation.expiryExpression();
        if (StringUtils.hasLength((String)expiryExpressionString)) {
            Assert.notNull((Object)environment, (String)"Environment must be set to use 'expiryExpression'");
            String expiryWithReplacedPlaceholders = environment.resolveRequiredPlaceholders(expiryExpressionString);
            try {
                expiryValue = Integer.parseInt(expiryWithReplacedPlaceholders);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Integer value for expiry expression: " + expiryWithReplacedPlaceholders);
            }
        }
        return expiryValue;
    }

    @Override
    public boolean isTouchOnRead() {
        Document annotation = this.getType().getAnnotation(Document.class);
        return annotation == null ? false : annotation.touchOnRead() && this.getExpiry() > 0;
    }

    @Override
    public boolean hasTextScoreProperty() {
        return false;
    }

    @Override
    public CouchbasePersistentProperty getTextScoreProperty() {
        return null;
    }
}

