/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.core.ResolvableType;
import org.springframework.data.javapoet.TypeNames;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.javapoet.TypeName;

public class MethodReturn {
    private final ReturnedType returnedType;
    private final Class<?> actualReturnClass;
    private final ResolvableType returnType;
    private final ResolvableType actualType;
    private final TypeName typeName;
    private final TypeName className;
    private final TypeName actualTypeName;
    private final TypeName actualClassName;

    public MethodReturn(ReturnedType returnedType, ResolvableType returnType) {
        TypeInformation<?> actualType;
        this.returnedType = returnedType;
        this.returnType = returnType;
        this.typeName = TypeNames.typeName(returnType);
        this.className = TypeNames.className(returnType);
        Class returnClass = returnType.toClass();
        TypeInformation<?> typeInformation = TypeInformation.of(returnType);
        TypeInformation<?> typeInformation2 = typeInformation.isMap() ? typeInformation : (actualType = typeInformation.getType().equals(Stream.class) ? typeInformation.getComponentType() : typeInformation.getActualType());
        if (actualType != null) {
            this.actualType = actualType.toResolvableType();
            this.actualTypeName = TypeNames.typeName(this.actualType);
            this.actualClassName = TypeNames.className(this.actualType);
            this.actualReturnClass = actualType.getType();
        } else {
            this.actualType = returnType;
            this.actualTypeName = this.typeName;
            this.actualClassName = this.className;
            this.actualReturnClass = returnClass;
        }
    }

    public boolean isProjecting() {
        return this.returnedType.isProjecting();
    }

    public boolean isInterfaceProjection() {
        return this.isProjecting() && this.returnedType.getReturnedType().isInterface();
    }

    public boolean isOptional() {
        return Optional.class.isAssignableFrom(this.toClass());
    }

    public boolean isArray() {
        return this.toClass().isArray();
    }

    public boolean isVoid() {
        return ReflectionUtils.isVoid(this.toClass());
    }

    public Class<?> toClass() {
        return this.returnType.toClass();
    }

    public ResolvableType getActualType() {
        return this.actualType;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public TypeName getClassName() {
        return this.className;
    }

    public TypeName getActualTypeName() {
        return this.actualTypeName;
    }

    public TypeName getActualClassName() {
        return this.actualClassName;
    }

    public Class<?> getActualReturnClass() {
        return this.actualReturnClass;
    }
}

