/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import org.jspecify.annotations.Nullable;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.DecoratingProxy;
import org.springframework.data.domain.AuditorAware;
import org.springframework.data.domain.ReactiveAuditorAware;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.util.ClassUtils;

class AuditingBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    AuditingBeanRegistrationAotProcessor() {
    }

    public @Nullable BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (AuditingBeanRegistrationAotProcessor.isAuditingHandler(registeredBean)) {
            return (generationContext, beanRegistrationCode) -> AuditingBeanRegistrationAotProcessor.registerSpringProxy(AuditorAware.class, generationContext.getRuntimeHints());
        }
        if (ReactiveWrappers.PROJECT_REACTOR_PRESENT && AuditingBeanRegistrationAotProcessor.isReactiveAuditorAware(registeredBean)) {
            return (generationContext, beanRegistrationCode) -> AuditingBeanRegistrationAotProcessor.registerSpringProxy(ReactiveAuditorAware.class, generationContext.getRuntimeHints());
        }
        return null;
    }

    private static boolean isAuditingHandler(RegisteredBean bean) {
        return ClassUtils.isAssignable(AuditorAware.class, (Class)bean.getBeanClass());
    }

    private static boolean isReactiveAuditorAware(RegisteredBean bean) {
        return ClassUtils.isAssignable(ReactiveAuditorAware.class, (Class)bean.getBeanClass());
    }

    private static void registerSpringProxy(Class<?> type, RuntimeHints runtimeHints) {
        runtimeHints.proxies().registerJdkProxy(new TypeReference[]{TypeReference.of(type), TypeReference.of(SpringProxy.class), TypeReference.of(Advised.class), TypeReference.of(DecoratingProxy.class)});
    }
}

