/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.AotRepositoryMethodBuilder;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;

public abstract class MethodContributor<M extends QueryMethod> {
    private final M queryMethod;
    private final QueryMetadata metadata;

    MethodContributor(M queryMethod, QueryMetadata metadata) {
        this.queryMethod = queryMethod;
        this.metadata = metadata;
    }

    public static <M extends QueryMethod> QueryMethodMetadataContributorBuilder<M> forQueryMethod(final M queryMethod) {
        return new QueryMethodMetadataContributorBuilder<M>(){

            @Override
            public MethodContributor<M> metadataOnly(QueryMetadata metadata) {
                return new MetadataContributor<QueryMethod>(queryMethod, metadata);
            }

            @Override
            public QueryMethodContributorBuilder<M> withMetadata(QueryMetadata metadata) {
                return contribution -> new GeneratedMethodContributor<QueryMethod>(queryMethod, metadata, b -> b.contribute(contribution::contribute));
            }
        };
    }

    public M getQueryMethod() {
        return this.queryMethod;
    }

    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public boolean contributesMethodSpec() {
        return false;
    }

    public abstract @Nullable MethodSpec contribute(AotQueryMethodGenerationContext var1);

    private static class GeneratedMethodContributor<M extends QueryMethod>
    extends MethodContributor<M> {
        private final Consumer<AotRepositoryMethodBuilder> builderConsumer;

        private GeneratedMethodContributor(M queryMethod, QueryMetadata metadata, Consumer<AotRepositoryMethodBuilder> builderConsumer) {
            super(queryMethod, metadata);
            this.builderConsumer = builderConsumer;
        }

        @Override
        public boolean contributesMethodSpec() {
            return true;
        }

        @Override
        public @NonNull MethodSpec contribute(AotQueryMethodGenerationContext context) {
            AotRepositoryMethodBuilder builder = new AotRepositoryMethodBuilder(context);
            this.builderConsumer.accept(builder);
            return builder.buildMethod();
        }
    }

    private static class MetadataContributor<M extends QueryMethod>
    extends MethodContributor<M> {
        private MetadataContributor(M queryMethod, QueryMetadata metadata) {
            super(queryMethod, metadata);
        }

        @Override
        public @Nullable MethodSpec contribute(AotQueryMethodGenerationContext context) {
            return null;
        }
    }

    public static interface RepositoryMethodCustomizer {
        public void customize(AotQueryMethodGenerationContext var1, MethodSpec.Builder var2);
    }

    public static interface RepositoryMethodContribution {
        public CodeBlock contribute(AotQueryMethodGenerationContext var1);
    }

    public static interface QueryMethodContributorBuilder<M extends QueryMethod> {
        public MethodContributor<M> contribute(RepositoryMethodContribution var1);
    }

    public static interface QueryMethodMetadataContributorBuilder<M extends QueryMethod> {
        public MethodContributor<M> metadataOnly(QueryMetadata var1);

        public QueryMethodContributorBuilder<M> withMetadata(QueryMetadata var1);
    }
}

