/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.data.aot.AotContext;
import org.springframework.data.aot.ManagedTypesRegistrationAotContribution;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.data.util.QTypeContributor;
import org.springframework.data.util.TypeContributor;
import org.springframework.data.util.TypeUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ManagedTypesBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private String moduleIdentifier;

    public void setModuleIdentifier(@Nullable String moduleIdentifier) {
        this.moduleIdentifier = moduleIdentifier;
    }

    @Nullable
    public String getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (!this.isMatch(registeredBean.getBeanClass(), registeredBean.getBeanName())) {
            return null;
        }
        ConfigurableListableBeanFactory beanFactory = registeredBean.getBeanFactory();
        return this.contribute(AotContext.from((BeanFactory)beanFactory), this.resolveManagedTypes(registeredBean), registeredBean);
    }

    private ManagedTypes resolveManagedTypes(RegisteredBean registeredBean) {
        block6: {
            Collection values;
            Object object;
            ConstructorArgumentValues.ValueHolder indexedArgumentValue;
            RootBeanDefinition beanDefinition = registeredBean.getMergedBeanDefinition();
            if (beanDefinition.hasConstructorArgumentValues() && (indexedArgumentValue = beanDefinition.getConstructorArgumentValues().getIndexedArgumentValue(0, null)) != null && (object = indexedArgumentValue.getValue()) instanceof Collection && (values = (Collection)object).stream().allMatch(it -> it instanceof Class)) {
                return ManagedTypes.fromIterable(values);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("ManagedTypes BeanDefinition '%s' does serve arguments. Trying to resolve bean instance.", registeredBean.getBeanName()));
            }
            if (registeredBean.getParent() == null) {
                try {
                    return (ManagedTypes)registeredBean.getBeanFactory().getBean(registeredBean.getBeanName(), ManagedTypes.class);
                }
                catch (BeanCreationException e) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)String.format("Could not resolve ManagedTypes '%s'.", registeredBean.getBeanName()));
                    }
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug((Object)e);
                }
            }
        }
        return ManagedTypes.empty();
    }

    protected BeanRegistrationAotContribution contribute(AotContext aotContext, ManagedTypes managedTypes, RegisteredBean registeredBean) {
        return new ManagedTypesRegistrationAotContribution(managedTypes, registeredBean, this::contributeType);
    }

    protected void contributeType(ResolvableType type, GenerationContext generationContext) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Contributing type information for [%s]", type.getType()));
        }
        Set<String> annotationNamespaces = Collections.singleton("org.springframework.data");
        Class resolvedType = type.toClass();
        TypeContributor.contribute(resolvedType, annotationNamespaces, generationContext);
        QTypeContributor.contributeEntityPath(resolvedType, generationContext, resolvedType.getClassLoader());
        TypeUtils.resolveUsedAnnotations(resolvedType).forEach(annotation -> TypeContributor.contribute(annotation.getType(), annotationNamespaces, generationContext));
    }

    protected boolean isMatch(@Nullable Class<?> beanType, @Nullable String beanName) {
        return this.matchesByType(beanType) && this.matchesPrefix(beanName);
    }

    protected boolean matchesByType(@Nullable Class<?> beanType) {
        return beanType != null && ClassUtils.isAssignable(ManagedTypes.class, beanType);
    }

    protected boolean matchesPrefix(@Nullable String beanName) {
        return StringUtils.startsWithIgnoreCase((String)beanName, (String)this.getModuleIdentifier());
    }
}

