/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.aot.DefaultAotContext;
import org.springframework.data.util.TypeScanner;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface AotContext {
    public static AotContext from(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        return new DefaultAotContext(beanFactory);
    }

    public ConfigurableListableBeanFactory getBeanFactory();

    @Nullable
    default public ClassLoader getClassLoader() {
        return this.getBeanFactory().getBeanClassLoader();
    }

    default public ClassLoader getRequiredClassLoader() {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            throw new IllegalStateException("Required ClassLoader is not available");
        }
        return loader;
    }

    public TypeIntrospector introspectType(String var1);

    default public TypeScanner getTypeScanner() {
        return TypeScanner.typeScanner(this.getRequiredClassLoader());
    }

    default public Set<Class<?>> scanPackageForTypes(Collection<Class<? extends Annotation>> identifyingAnnotations, Collection<String> packageNames) {
        return this.getTypeScanner().scanPackages(packageNames).forTypesAnnotatedWith(identifyingAnnotations).collectAsSet();
    }

    default public IntrospectedBeanDefinition introspectBeanDefinition(BeanReference reference) {
        return this.introspectBeanDefinition(reference.getBeanName());
    }

    public IntrospectedBeanDefinition introspectBeanDefinition(String var1);

    public static interface IntrospectedBeanDefinition {
        public boolean isPresent();

        public boolean isFactoryBean();

        public BeanDefinition getBeanDefinition() throws NoSuchBeanDefinitionException;

        public RootBeanDefinition getRootBeanDefinition() throws NoSuchBeanDefinitionException;

        @Nullable
        public Class<?> resolveType();
    }

    public static interface TypeIntrospector {
        public boolean isTypePresent();

        public Class<?> resolveRequiredType() throws TypeNotPresentException;

        public Optional<Class<?>> resolveType();

        default public void ifTypePresent(Consumer<Class<?>> action) {
            this.resolveType().ifPresent(action);
        }

        public boolean hasBean();

        public List<String> getBeanNames();
    }
}

