/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.util.Assert;

class DefaultProjectionInformation
implements ProjectionInformation {
    private final Class<?> projectionType;
    private final List<PropertyDescriptor> properties;

    public DefaultProjectionInformation(Class<?> type) {
        Assert.notNull(type, (String)"Projection type must not be null!");
        this.projectionType = type;
        this.properties = DefaultProjectionInformation.collectDescriptors(type);
    }

    @Override
    public Class<?> getType() {
        return this.projectionType;
    }

    @Override
    public List<PropertyDescriptor> getInputProperties() {
        return this.properties.stream().filter(this::isInputProperty).distinct().collect(Collectors.toList());
    }

    @Override
    public boolean isClosed() {
        return this.properties.equals(this.getInputProperties());
    }

    protected boolean isInputProperty(PropertyDescriptor descriptor) {
        return true;
    }

    private static List<PropertyDescriptor> collectDescriptors(Class<?> type) {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        result.addAll(Arrays.stream(BeanUtils.getPropertyDescriptors(type)).filter(it -> !DefaultProjectionInformation.hasDefaultGetter(it)).collect(Collectors.toList()));
        for (Class<?> interfaze : type.getInterfaces()) {
            result.addAll(DefaultProjectionInformation.collectDescriptors(interfaze));
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    private static boolean hasDefaultGetter(PropertyDescriptor descriptor) {
        Method method = descriptor.getReadMethod();
        return method == null ? false : method.isDefault();
    }
}

