/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.beans.ConstructorProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.DefaultPersistentPropertyPath;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mapping.model.ClassGeneratingPropertyAccessorFactory;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.Pair;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMappingContext<E extends MutablePersistentEntity<?, P>, P extends PersistentProperty<P>>
implements MappingContext<E, P>,
ApplicationEventPublisherAware,
InitializingBean {
    private final Optional<E> NONE = Optional.empty();
    private final Map<TypeInformation<?>, Optional<E>> persistentEntities = new HashMap();
    private final Map<TypeAndProperties, PersistentPropertyPath<P>> propertyPaths = new ConcurrentReferenceHashMap();
    private final PersistentPropertyAccessorFactory persistentPropertyAccessorFactory = new ClassGeneratingPropertyAccessorFactory();
    @Nullable
    private ApplicationEventPublisher applicationEventPublisher;
    private Set<? extends Class<?>> initialEntitySet = new HashSet();
    private boolean strict = false;
    private SimpleTypeHolder simpleTypeHolder = SimpleTypeHolder.DEFAULT;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setInitialEntitySet(Set<? extends Class<?>> initialEntitySet) {
        this.initialEntitySet = initialEntitySet;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSimpleTypeHolder(SimpleTypeHolder simpleTypes) {
        Assert.notNull((Object)simpleTypes, (String)"SimpleTypeHolder must not be null!");
        this.simpleTypeHolder = simpleTypes;
    }

    @Override
    public Collection<E> getPersistentEntities() {
        try {
            this.read.lock();
            Collection collection = this.persistentEntities.values().stream().flatMap(xva$0 -> Optionals.toStream(xva$0)).collect(Collectors.toSet());
            return collection;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    @Nullable
    public E getPersistentEntity(Class<?> type) {
        return (E)this.getPersistentEntity(ClassTypeInformation.from(type));
    }

    @Override
    public boolean hasPersistentEntityFor(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        Optional<E> entity = this.persistentEntities.get(ClassTypeInformation.from(type));
        return entity == null ? false : entity.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public E getPersistentEntity(TypeInformation<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            this.read.lock();
            Optional<E> entity = this.persistentEntities.get(type);
            if (entity != null) {
                MutablePersistentEntity mutablePersistentEntity = entity.orElse(null);
                return (E)mutablePersistentEntity;
            }
        }
        finally {
            this.read.unlock();
        }
        if (!this.shouldCreatePersistentEntityFor(type)) {
            try {
                this.write.lock();
                this.persistentEntities.put(type, this.NONE);
            }
            finally {
                this.write.unlock();
            }
            return null;
        }
        if (this.strict) {
            throw new MappingException("Unknown persistent entity " + type);
        }
        return (E)((MutablePersistentEntity)this.addPersistentEntity(type).orElse(null));
    }

    @Override
    @Nullable
    public E getPersistentEntity(P persistentProperty) {
        Assert.notNull(persistentProperty, (String)"PersistentProperty must not be null!");
        if (!persistentProperty.isEntity()) {
            return null;
        }
        TypeInformation<?> typeInfo = persistentProperty.getTypeInformation();
        return (E)this.getPersistentEntity((TypeInformation)typeInfo.getRequiredActualType());
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(PropertyPath propertyPath) {
        Assert.notNull((Object)propertyPath, (String)"Property path must not be null!");
        return this.getPersistentPropertyPath(propertyPath.toDotPath(), propertyPath.getOwningType());
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(String propertyPath, Class<?> type) {
        Assert.notNull((Object)propertyPath, (String)"Property path must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.getPersistentPropertyPath(propertyPath, ClassTypeInformation.from(type));
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(InvalidPersistentPropertyPath invalidPath) {
        return this.getPersistentPropertyPath(invalidPath.getResolvedPath(), invalidPath.getType());
    }

    @Override
    private PersistentPropertyPath<P> getPersistentPropertyPath(String propertyPath, TypeInformation<?> type) {
        return this.propertyPaths.computeIfAbsent(TypeAndProperties.of(type, propertyPath), it -> this.createPersistentPropertyPath(it.getPath(), it.getType()));
    }

    private PersistentPropertyPath<P> createPersistentPropertyPath(String propertyPath, TypeInformation<?> type) {
        List<String> parts = Arrays.asList(propertyPath.split("\\."));
        DefaultPersistentPropertyPath path = DefaultPersistentPropertyPath.empty();
        Iterator<String> iterator = parts.iterator();
        MutablePersistentEntity current = (MutablePersistentEntity)this.getRequiredPersistentEntity(type);
        while (iterator.hasNext()) {
            String segment = iterator.next();
            DefaultPersistentPropertyPath foo = path;
            MutablePersistentEntity bar = current;
            Pair pair = this.getPair(path, iterator, segment, current);
            if (pair == null) {
                String source = StringUtils.collectionToDelimitedString(parts, (String)".");
                String resolvedPath = foo.toDotPath();
                throw new InvalidPersistentPropertyPath(source, type, segment, resolvedPath, String.format("No property %s found on %s!", segment, bar.getName()));
            }
            path = pair.getFirst();
            current = pair.getSecond();
        }
        return path;
    }

    @Nullable
    private Pair<DefaultPersistentPropertyPath<P>, E> getPair(DefaultPersistentPropertyPath<P> path, Iterator<String> iterator, String segment, E entity) {
        Object property = entity.getPersistentProperty(segment);
        if (property == null) {
            return null;
        }
        TypeInformation<?> type = property.getTypeInformation().getRequiredActualType();
        return Pair.of(path.append(property), iterator.hasNext() ? (MutablePersistentEntity)this.getRequiredPersistentEntity(type) : entity);
    }

    protected Optional<E> addPersistentEntity(Class<?> type) {
        return this.addPersistentEntity(ClassTypeInformation.from(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<E> addPersistentEntity(TypeInformation<?> typeInformation) {
        Assert.notNull(typeInformation, (String)"TypeInformation must not be null!");
        try {
            this.read.lock();
            Optional<E> persistentEntity = this.persistentEntities.get(typeInformation);
            if (persistentEntity != null) {
                Optional<E> optional = persistentEntity;
                return optional;
            }
        }
        finally {
            this.read.unlock();
        }
        Class<?> type = typeInformation.getType();
        MutablePersistentEntity entity = null;
        try {
            this.write.lock();
            entity = (MutablePersistentEntity)this.createPersistentEntity(typeInformation);
            this.persistentEntities.put(typeInformation, Optional.of(entity));
            PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(type);
            HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor descriptor : pds) {
                descriptors.put(descriptor.getName(), descriptor);
            }
            try {
                PersistentPropertyCreator persistentPropertyCreator = new PersistentPropertyCreator(this, entity, descriptors);
                org.springframework.util.ReflectionUtils.doWithFields(type, (ReflectionUtils.FieldCallback)persistentPropertyCreator, (ReflectionUtils.FieldFilter)PersistentPropertyFilter.INSTANCE);
                persistentPropertyCreator.addPropertiesForRemainingDescriptors();
                entity.verify();
                if (this.persistentPropertyAccessorFactory.isSupported(entity)) {
                    entity.setPersistentPropertyAccessorFactory(this.persistentPropertyAccessorFactory);
                }
            }
            catch (MappingException e) {
                this.persistentEntities.remove(typeInformation);
                throw e;
            }
        }
        catch (BeansException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            this.write.unlock();
        }
        if (this.applicationEventPublisher != null && entity != null) {
            this.applicationEventPublisher.publishEvent(new MappingContextEvent(this, entity));
        }
        return Optional.of(entity);
    }

    @Override
    public Collection<TypeInformation<?>> getManagedTypes() {
        try {
            this.read.lock();
            Set<TypeInformation<?>> set = Collections.unmodifiableSet(new HashSet(this.persistentEntities.keySet()));
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    protected abstract <T> E createPersistentEntity(TypeInformation<T> var1);

    protected abstract P createPersistentProperty(Property var1, E var2, SimpleTypeHolder var3);

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void initialize() {
        this.initialEntitySet.forEach(this::addPersistentEntity);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        if (this.simpleTypeHolder.isSimpleType(type.getType())) {
            return false;
        }
        return !ReflectionUtils.isKotlinClass(type.getType()) || ReflectionUtils.isSupportedKotlinClass(type.getType());
    }

    static enum PersistentPropertyFilter implements ReflectionUtils.FieldFilter
    {
        INSTANCE;

        private static final Streamable<PropertyMatch> UNMAPPED_PROPERTIES;

        public boolean matches(Field field) {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            return !UNMAPPED_PROPERTIES.stream().anyMatch(it -> it.matches(field.getName(), field.getType()));
        }

        public boolean matches(Property property) {
            Assert.notNull((Object)property, (String)"Property must not be null!");
            if (!property.hasAccessor()) {
                return false;
            }
            return !UNMAPPED_PROPERTIES.stream().anyMatch(it -> it.matches(property.getName(), property.getType()));
        }

        static {
            HashSet<PropertyMatch> matches = new HashSet<PropertyMatch>();
            matches.add(new PropertyMatch("class", null));
            matches.add(new PropertyMatch("this\\$.*", null));
            matches.add(new PropertyMatch("metaClass", "groovy.lang.MetaClass"));
            UNMAPPED_PROPERTIES = Streamable.of(matches);
        }

        static class PropertyMatch {
            @Nullable
            private final String namePattern;
            @Nullable
            private final String typeName;

            public PropertyMatch(@Nullable String namePattern, @Nullable String typeName) {
                Assert.isTrue((namePattern != null || typeName != null ? 1 : 0) != 0, (String)"Either name pattern or type name must be given!");
                this.namePattern = namePattern;
                this.typeName = typeName;
            }

            public boolean matches(String name, Class<?> type) {
                Assert.notNull((Object)name, (String)"Name must not be null!");
                Assert.notNull(type, (String)"Type must not be null!");
                if (this.namePattern != null && !name.matches(this.namePattern)) {
                    return false;
                }
                return this.typeName == null || type.getName().equals(this.typeName);
            }
        }
    }

    static final class TypeAndProperties {
        private final TypeInformation<?> type;
        private final String path;

        @ConstructorProperties(value={"type", "path"})
        private TypeAndProperties(TypeInformation<?> type, String path) {
            this.type = type;
            this.path = path;
        }

        public static TypeAndProperties of(TypeInformation<?> type, String path) {
            return new TypeAndProperties(type, path);
        }

        public TypeInformation<?> getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeAndProperties)) {
                return false;
            }
            TypeAndProperties other = (TypeAndProperties)o;
            TypeInformation<?> this$type = this.getType();
            TypeInformation<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeInformation<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractMappingContext.TypeAndProperties(type=" + this.getType() + ", path=" + this.getPath() + ")";
        }
    }

    private static final class PersistentPropertyCreator
    implements ReflectionUtils.FieldCallback {
        @NonNull
        private final E entity;
        @NonNull
        private final Map<String, PropertyDescriptor> descriptors;
        @NonNull
        private final Map<String, PropertyDescriptor> remainingDescriptors;
        final /* synthetic */ AbstractMappingContext this$0;

        public PersistentPropertyCreator(E entity, Map<String, PropertyDescriptor> descriptors) {
            this(var1_1, (MutablePersistentEntity)entity, descriptors, descriptors);
        }

        public void doWith(Field field) {
            String fieldName = field.getName();
            TypeInformation type = this.entity.getTypeInformation();
            org.springframework.util.ReflectionUtils.makeAccessible((Field)field);
            Property property = Optional.ofNullable(this.descriptors.get(fieldName)).map(it -> Property.of(type, field, it)).orElseGet(() -> Property.of(type, field));
            this.createAndRegisterProperty(property);
            this.remainingDescriptors.remove(fieldName);
        }

        public void addPropertiesForRemainingDescriptors() {
            this.remainingDescriptors.values().stream().filter(Property::supportsStandalone).map(it -> Property.of(this.entity.getTypeInformation(), it)).filter(PersistentPropertyFilter.INSTANCE::matches).forEach(this::createAndRegisterProperty);
        }

        private void createAndRegisterProperty(Property input) {
            Object property = this.this$0.createPersistentProperty(input, this.entity, this.this$0.simpleTypeHolder);
            if (property.isTransient()) {
                return;
            }
            if (!input.isFieldBacked() && !property.usePropertyAccess()) {
                return;
            }
            this.entity.addPersistentProperty(property);
            if (property.isAssociation()) {
                this.entity.addAssociation(property.getRequiredAssociation());
            }
            if (this.entity.getType().equals(property.getRawType())) {
                return;
            }
            property.getPersistentEntityTypes().forEach(this.this$0::addPersistentEntity);
        }

        @ConstructorProperties(value={"entity", "descriptors", "remainingDescriptors"})
        private PersistentPropertyCreator(@NonNull E entity, @NonNull Map<String, PropertyDescriptor> descriptors, Map<String, PropertyDescriptor> remainingDescriptors) {
            this.this$0 = var1_1;
            if (entity == null) {
                throw new IllegalArgumentException("entity is null");
            }
            if (descriptors == null) {
                throw new IllegalArgumentException("descriptors is null");
            }
            if (remainingDescriptors == null) {
                throw new IllegalArgumentException("remainingDescriptors is null");
            }
            this.entity = entity;
            this.descriptors = descriptors;
            this.remainingDescriptors = remainingDescriptors;
        }
    }
}

