/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.io.IOException;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.web.ProjectedPayload;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.xmlbeam.ProjectionFactory;
import org.xmlbeam.XBProjector;

public class XmlBeamHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private final ProjectionFactory projectionFactory;
    private final Map<Class<?>, Boolean> supportedTypesCache = new ConcurrentReferenceHashMap();

    public XmlBeamHttpMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_XML, MediaType.parseMediaType((String)"application/*+xml")});
        this.projectionFactory = new XBProjector(new XBProjector.Flags[0]);
    }

    protected boolean supports(Class<?> type) {
        Class rawType = ResolvableType.forType(type).getRawClass();
        Boolean result = this.supportedTypesCache.get(rawType);
        if (result != null) {
            return result;
        }
        result = rawType.isInterface() && AnnotationUtils.findAnnotation((Class)rawType, ProjectedPayload.class) != null;
        this.supportedTypesCache.put(rawType, result);
        return result;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.projectionFactory.io().stream(inputMessage.getBody()).read(clazz);
    }

    protected void writeInternal(Object t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
    }
}

