/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.CollectionPathBase;
import java.beans.ConstructorProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.binding.PathInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ReflectionUtils;

class PropertyPathInformation
implements PathInformation {
    private final PropertyPath path;

    public static PropertyPathInformation of(String path, Class<?> type) {
        return PropertyPathInformation.of(PropertyPath.from(path, type));
    }

    public static PropertyPathInformation of(String path, TypeInformation<?> type) {
        return PropertyPathInformation.of(PropertyPath.from(path, type));
    }

    @Override
    public Class<?> getLeafType() {
        return this.path.getLeafProperty().getType();
    }

    @Override
    public Class<?> getLeafParentType() {
        return this.path.getLeafProperty().getOwningType().getType();
    }

    @Override
    public String getLeafProperty() {
        return this.path.getLeafProperty().getSegment();
    }

    @Override
    public PropertyDescriptor getLeafPropertyDescriptor() {
        return BeanUtils.getPropertyDescriptor(this.getLeafParentType(), (String)this.getLeafProperty());
    }

    @Override
    public String toDotPath() {
        return this.path.toDotPath();
    }

    @Override
    public Path<?> reifyPath(EntityPathResolver resolver) {
        return PropertyPathInformation.reifyPath(resolver, this.path, null);
    }

    private static Path<?> reifyPath(EntityPathResolver resolver, PropertyPath path, Path<?> base) {
        if (base instanceof CollectionPathBase) {
            return PropertyPathInformation.reifyPath(resolver, path, (Path)((CollectionPathBase)base).any());
        }
        Path<?> entityPath = base != null ? base : resolver.createPath(path.getOwningType().getType());
        Field field = ReflectionUtils.findField(entityPath.getClass(), (String)path.getSegment());
        Object value = ReflectionUtils.getField((Field)field, entityPath);
        if (path.hasNext()) {
            return PropertyPathInformation.reifyPath(resolver, path.next(), (Path)value);
        }
        return (Path)value;
    }

    public String toString() {
        return "PropertyPathInformation(path=" + this.path + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyPathInformation)) {
            return false;
        }
        PropertyPathInformation other = (PropertyPathInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PropertyPath this$path = this.path;
        PropertyPath other$path = other.path;
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyPathInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PropertyPath $path = this.path;
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    @ConstructorProperties(value={"path"})
    private PropertyPathInformation(PropertyPath path) {
        this.path = path;
    }

    private static PropertyPathInformation of(PropertyPath path) {
        return new PropertyPathInformation(path);
    }
}

