/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.config.CompressionType;
import org.springframework.data.cassandra.config.CqlSessionFactoryBean;
import org.springframework.data.cassandra.config.DriverConfigLoaderBuilderConfigurer;
import org.springframework.data.cassandra.config.SessionBuilderConfigurer;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractSessionConfiguration
implements BeanFactoryAware {
    @Nullable
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory not initialized");
        return this.beanFactory;
    }

    protected <T> T requireBeanOfType(@NonNull Class<T> beanType) {
        return (T)this.getBeanFactory().getBean(beanType);
    }

    @Nullable
    @Deprecated(forRemoval=true)
    protected String getClusterName() {
        return null;
    }

    protected abstract String getKeyspaceName();

    @Nullable
    protected String getLocalDataCenter() {
        return "datacenter1";
    }

    @Nullable
    protected String getSessionName() {
        return null;
    }

    @Nullable
    protected CompressionType getCompressionType() {
        return null;
    }

    protected String getContactPoints() {
        return "localhost";
    }

    protected int getPort() {
        return 9042;
    }

    protected List<CreateKeyspaceSpecification> getKeyspaceCreations() {
        return Collections.emptyList();
    }

    protected List<DropKeyspaceSpecification> getKeyspaceDrops() {
        return Collections.emptyList();
    }

    protected CqlSession getRequiredSession() {
        return this.requireBeanOfType(CqlSession.class);
    }

    protected SessionFactory getRequiredSessionFactory() {
        ObjectProvider beanProvider = this.getBeanFactory().getBeanProvider(SessionFactory.class);
        return (SessionFactory)beanProvider.getIfAvailable(() -> new DefaultSessionFactory(this.requireBeanOfType(CqlSession.class)));
    }

    @Nullable
    protected SessionBuilderConfigurer getSessionBuilderConfigurer() {
        return null;
    }

    @Nullable
    protected DriverConfigLoaderBuilderConfigurer getDriverConfigLoaderBuilderConfigurer() {
        return null;
    }

    @Nullable
    protected Resource getDriverConfigurationResource() {
        return null;
    }

    @Deprecated(forRemoval=true)
    protected List<String> getStartupScripts() {
        return Collections.emptyList();
    }

    @Deprecated(forRemoval=true)
    protected List<String> getShutdownScripts() {
        return Collections.emptyList();
    }

    @Bean
    public CqlSessionFactoryBean cassandraSession() {
        CqlSessionFactoryBean bean = new CqlSessionFactoryBean();
        bean.setContactPoints(this.getContactPoints());
        bean.setKeyspaceCreations(this.getKeyspaceCreations());
        bean.setKeyspaceDrops(this.getKeyspaceDrops());
        bean.setKeyspaceName(this.getKeyspaceName());
        bean.setKeyspaceStartupScripts(this.getStartupScripts());
        bean.setKeyspaceShutdownScripts(this.getShutdownScripts());
        bean.setLocalDatacenter(this.getLocalDataCenter());
        bean.setPort(this.getPort());
        bean.setSessionBuilderConfigurer(this.getSessionBuilderConfigurerWrapper());
        return bean;
    }

    private SessionBuilderConfigurer getSessionBuilderConfigurerWrapper() {
        SessionBuilderConfigurer sessionConfigurer = this.getSessionBuilderConfigurer();
        DriverConfigLoaderBuilderConfigurer driverConfigLoaderConfigurer = this.getDriverConfigLoaderBuilderConfigurer();
        Resource driverConfigFile = this.getDriverConfigurationResource();
        return sessionBuilder -> {
            DefaultProgrammaticDriverConfigLoaderBuilder builder = new DefaultProgrammaticDriverConfigLoaderBuilder(() -> {
                CassandraDriverOptions options = new CassandraDriverOptions();
                if (StringUtils.hasText((String)this.getSessionName())) {
                    options.add((DriverOption)DefaultDriverOption.SESSION_NAME, this.getSessionName());
                } else if (StringUtils.hasText((String)this.getClusterName())) {
                    options.add((DriverOption)DefaultDriverOption.SESSION_NAME, this.getClusterName());
                }
                CompressionType compressionType = this.getCompressionType();
                if (compressionType != null) {
                    options.add((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, compressionType);
                }
                ConfigFactory.invalidateCaches();
                Config config = ConfigFactory.defaultOverrides().withFallback((ConfigMergeable)options.build());
                if (driverConfigFile != null) {
                    try {
                        config = config.withFallback((ConfigMergeable)ConfigFactory.parseReader((Reader)new InputStreamReader(driverConfigFile.getInputStream())));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("Cannot parse driver config file %s", driverConfigFile), e);
                    }
                }
                return config.withFallback((ConfigMergeable)ConfigFactory.defaultReference());
            }, "datastax-java-driver");
            if (driverConfigLoaderConfigurer != null) {
                driverConfigLoaderConfigurer.configure((ProgrammaticDriverConfigLoaderBuilder)builder);
            }
            sessionBuilder.withConfigLoader(builder.build());
            if (sessionConfigurer != null) {
                return sessionConfigurer.configure(sessionBuilder);
            }
            return sessionBuilder;
        };
    }

    @Bean
    public CqlTemplate cqlTemplate() {
        return new CqlTemplate(this.getRequiredSessionFactory());
    }

    private static class CassandraDriverOptions {
        private final Map<String, String> options = new LinkedHashMap<String, String>();

        private CassandraDriverOptions() {
        }

        private CassandraDriverOptions add(DriverOption option, String value) {
            this.options.put(option.getPath(), value);
            return this;
        }

        private CassandraDriverOptions add(DriverOption option, Enum<?> value) {
            return this.add(option, value.name());
        }

        private Config build() {
            return ConfigFactory.parseMap(this.options, (String)"Environment");
        }
    }
}

