/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Column;
import org.springframework.data.cassandra.core.mapping.Element;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

class AnnotatedCassandraConstructorProperty
implements CassandraPersistentProperty {
    private final CassandraPersistentProperty delegate;
    private final MergedAnnotation<Column> column;
    private final MergedAnnotation<Element> element;

    public AnnotatedCassandraConstructorProperty(CassandraPersistentProperty delegate, MergedAnnotations annotations) {
        this.delegate = delegate;
        this.column = annotations.get(Column.class);
        this.element = annotations.get(Element.class);
    }

    @Override
    @Nullable
    public CqlIdentifier getColumnName() {
        return this.column.isPresent() ? CqlIdentifier.fromCql((String)this.column.getString("value")) : this.delegate.getColumnName();
    }

    @Override
    public boolean hasExplicitColumnName() {
        return this.column.isPresent() && !ObjectUtils.isEmpty((Object)this.column.getString("value"));
    }

    @Override
    @Nullable
    public Integer getOrdinal() {
        return this.element.isPresent() ? Integer.valueOf(this.element.getInt("value")) : this.delegate.getOrdinal();
    }

    @Override
    @Nullable
    public Ordering getPrimaryKeyOrdering() {
        return this.delegate.getPrimaryKeyOrdering();
    }

    @Override
    public boolean isClusterKeyColumn() {
        return this.delegate.isClusterKeyColumn();
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return this.delegate.isCompositePrimaryKey();
    }

    @Override
    public boolean isMapLike() {
        return this.delegate.isMapLike();
    }

    @Override
    public boolean isPartitionKeyColumn() {
        return this.delegate.isPartitionKeyColumn();
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return this.delegate.isPrimaryKeyColumn();
    }

    @Override
    public boolean isStaticColumn() {
        return this.delegate.isStaticColumn();
    }

    @Override
    @Nullable
    public AnnotatedType findAnnotatedType(Class<? extends Annotation> annotationType) {
        return this.delegate.findAnnotatedType(annotationType);
    }

    public PersistentEntity<?, CassandraPersistentProperty> getOwner() {
        return this.delegate.getOwner();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Class<?> getType() {
        return this.delegate.getType();
    }

    public TypeInformation<?> getTypeInformation() {
        return this.delegate.getTypeInformation();
    }

    @Nullable
    public Method getGetter() {
        return this.delegate.getGetter();
    }

    @Nullable
    public Method getSetter() {
        return this.delegate.getSetter();
    }

    @Nullable
    public Method getWither() {
        return this.delegate.getWither();
    }

    @Nullable
    public Field getField() {
        return this.delegate.getField();
    }

    @Nullable
    public String getSpelExpression() {
        return this.delegate.getSpelExpression();
    }

    @Nullable
    public Association<CassandraPersistentProperty> getAssociation() {
        return this.delegate.getAssociation();
    }

    public boolean isEntity() {
        return this.delegate.isEntity();
    }

    public boolean isIdProperty() {
        return this.delegate.isIdProperty();
    }

    public boolean isVersionProperty() {
        return this.delegate.isVersionProperty();
    }

    public boolean isCollectionLike() {
        return this.delegate.isCollectionLike();
    }

    public boolean isMap() {
        return this.delegate.isMap();
    }

    public boolean isArray() {
        return this.delegate.isArray();
    }

    public boolean isTransient() {
        return this.delegate.isTransient();
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public boolean isImmutable() {
        return this.delegate.isImmutable();
    }

    public boolean isAssociation() {
        return this.delegate.isAssociation();
    }

    @Nullable
    public Class<?> getComponentType() {
        return this.delegate.getComponentType();
    }

    public Class<?> getRawType() {
        return this.delegate.getRawType();
    }

    @Nullable
    public Class<?> getMapValueType() {
        return this.delegate.getMapValueType();
    }

    public Class<?> getActualType() {
        return this.delegate.getActualType();
    }

    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return (A)this.delegate.findAnnotation(annotationType);
    }

    @Nullable
    public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        return (A)this.delegate.findPropertyOrOwnerAnnotation(annotationType);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.delegate.isAnnotationPresent(annotationType);
    }

    public boolean usePropertyAccess() {
        return this.delegate.usePropertyAccess();
    }

    @Nullable
    public Class<?> getAssociationTargetType() {
        return this.delegate.getAssociationTargetType();
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation() {
        return this.delegate.getPersistentEntityTypeInformation();
    }

    @Nullable
    public TypeInformation<?> getAssociationTargetTypeInformation() {
        return this.delegate.getAssociationTargetTypeInformation();
    }

    @Override
    public void setColumnName(CqlIdentifier columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated(forRemoval=true)
    public void setForceQuote(boolean forceQuote) {
        throw new UnsupportedOperationException();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        throw new UnsupportedOperationException();
    }
}

