/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.VectorType;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.cql.PrimaryKeyType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ColumnSpecification {
    public static final Ordering DEFAULT_ORDERING = Ordering.ASCENDING;
    private final CqlIdentifier name;
    @Nullable
    private DataType type;
    @Nullable
    private PrimaryKeyType keyType;
    @Nullable
    private Ordering ordering;
    private boolean isStatic;

    private ColumnSpecification(CqlIdentifier name) {
        this.name = name;
    }

    public static ColumnSpecification name(String name) {
        return ColumnSpecification.name(CqlIdentifier.fromCql((String)name));
    }

    public static ColumnSpecification name(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"CqlIdentifier must not be null");
        return new ColumnSpecification(name);
    }

    public ColumnSpecification type(DataType type) {
        Assert.notNull((Object)type, (String)"DataType must not be null");
        this.type = type;
        return this;
    }

    public ColumnSpecification partitioned() {
        return this.partitioned(true);
    }

    public ColumnSpecification partitioned(boolean partitioned) {
        this.keyType = partitioned ? PrimaryKeyType.PARTITIONED : null;
        this.ordering = null;
        return this;
    }

    public ColumnSpecification clustered() {
        return this.clustered(DEFAULT_ORDERING);
    }

    public ColumnSpecification clustered(Ordering order) {
        return this.clustered(order, true);
    }

    public ColumnSpecification clustered(Ordering order, boolean primary) {
        this.keyType = primary ? PrimaryKeyType.CLUSTERED : null;
        this.ordering = primary ? order : null;
        return this;
    }

    public ColumnSpecification keyType(PrimaryKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public ColumnSpecification ordering(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    public ColumnSpecification staticColumn() {
        this.isStatic = true;
        return this;
    }

    public CqlIdentifier getName() {
        return this.name;
    }

    @Nullable
    public DataType getType() {
        return this.type;
    }

    @Nullable
    public PrimaryKeyType getKeyType() {
        return this.keyType;
    }

    @Nullable
    public Ordering getOrdering() {
        return this.ordering;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String toCql() {
        return this.toCql(new StringBuilder()).toString();
    }

    public StringBuilder toCql(StringBuilder cql) {
        return cql.append(this.name.asCql(true)).append(" ").append(this.renderType());
    }

    private String renderType() {
        DataType dataType = this.type;
        if (dataType instanceof VectorType) {
            VectorType vt = (VectorType)dataType;
            return "vector<%s, %d>".formatted(vt.getElementType().asCql(true, true), vt.getDimensions());
        }
        return this.type.asCql(true, true);
    }

    public String toString() {
        return this.toCql(new StringBuilder()).append(" /* ").append("keyType=").append((Object)this.keyType).append(", ").append("ordering=").append((Object)this.ordering).append(", ").append("isStatic=").append(this.isStatic).append(" */ ").toString();
    }
}

