/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.cdi.CassandraRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class CassandraRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private final Map<Set<Annotation>, Bean<CassandraOperations>> cassandraOperationsMap = new HashMap<Set<Annotation>, Bean<CassandraOperations>>();

    <T> void processBean(@Observes ProcessBean<T> processBean) {
        Bean bean = processBean.getBean();
        bean.getTypes().stream().filter(type -> type instanceof Class && CassandraOperations.class.isAssignableFrom((Class)type)).forEach(type -> this.cassandraOperationsMap.put(bean.getQualifiers(), (Bean<CassandraOperations>)bean));
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            afterBeanDiscovery.addBean(repositoryBean);
            this.registerBean(repositoryBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<CassandraOperations> cassandraOperationsBean = Optional.ofNullable(this.cassandraOperationsMap.get(qualifiers)).orElseThrow(() -> new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s", CassandraOperations.class.getName(), qualifiers)));
        return new CassandraRepositoryBean<T>(cassandraOperationsBean, qualifiers, repositoryType, beanManager, this.getCustomImplementationDetector());
    }
}

