/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Criteria;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.repository.ReactiveCassandraRepository;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.FindByIdQuery;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveCassandraRepository<T, ID>
implements ReactiveCassandraRepository<T, ID> {
    private static final InsertOptions INSERT_NULLS = InsertOptions.builder().withInsertNulls().build();
    private final AbstractMappingContext<BasicCassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final CassandraEntityInformation<T, ID> entityInformation;
    private final ReactiveCassandraOperations operations;

    public SimpleReactiveCassandraRepository(CassandraEntityInformation<T, ID> metadata, ReactiveCassandraOperations operations) {
        Assert.notNull(metadata, (String)"CassandraEntityInformation must not be null");
        Assert.notNull((Object)operations, (String)"ReactiveCassandraOperations must not be null");
        this.entityInformation = metadata;
        this.operations = operations;
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        if (persistentEntity != null && persistentEntity.hasVersionProperty() && !this.entityInformation.isNew(entity)) {
            return this.operations.update(entity);
        }
        return this.operations.insert(entity, INSERT_NULLS).map(EntityWriteResult::getEntity);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        return this.saveAll((Publisher<S>)Flux.fromIterable(entities));
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null");
        return Flux.from(entityStream).flatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return this.operations.selectOneById(id, this.entityInformation.getJavaType());
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The Publisher of ids must not be null");
        return Mono.from(publisher).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return this.operations.exists(id, this.entityInformation.getJavaType());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The Publisher of ids must not be null");
        return Mono.from(publisher).flatMap(this::existsById);
    }

    public Flux<T> findAll() {
        return this.operations.select(Query.empty(), this.entityInformation.getJavaType());
    }

    @Override
    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null");
        if (FindByIdQuery.hasCompositeKeys(ids, this.mappingContext)) {
            return this.findAllById((Publisher<ID>)Flux.fromIterable(ids));
        }
        if (!ids.iterator().hasNext()) {
            return Flux.empty();
        }
        return this.operations.select(this.createIdsInCollectionQuery(ids), this.entityInformation.getJavaType());
    }

    @Override
    public Flux<T> findAllById(Publisher<ID> idStream) {
        Assert.notNull(idStream, (String)"The given Publisher of ids must not be null");
        return Flux.from(idStream).flatMap(this::findById);
    }

    public Mono<Long> count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return this.operations.deleteById(id, this.entityInformation.getJavaType()).then();
    }

    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The Publisher of ids must not be null");
        return Mono.from(publisher).flatMap(this::deleteById).then();
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        return this.operations.delete(entity).then();
    }

    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null");
        if (FindByIdQuery.hasCompositeKeys(ids, this.mappingContext)) {
            return Flux.fromIterable(ids).flatMap(this::deleteById).then();
        }
        if (!ids.iterator().hasNext()) {
            return Mono.empty();
        }
        return this.operations.delete(this.createIdsInCollectionQuery(ids), this.entityInformation.getJavaType()).then();
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        return Flux.fromIterable(entities).flatMap(this.operations::delete).then();
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null");
        return Flux.from(entityStream).flatMap(this.operations::delete).then();
    }

    public Mono<Void> deleteAll() {
        return this.operations.truncate(this.entityInformation.getJavaType());
    }

    @Override
    public <S extends T> Mono<S> insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.operations.insert(entity);
    }

    @Override
    public <S extends T> Flux<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        return Flux.fromIterable(entities).flatMap(this.operations::insert);
    }

    @Override
    public <S extends T> Flux<S> insert(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null");
        return Flux.from(entityStream).flatMap(this.operations::insert);
    }

    private Query createIdsInCollectionQuery(Iterable<? extends ID> ids) {
        FindByIdQuery query2 = FindByIdQuery.forIds(ids);
        List<Object> idCollection = query2.getIdCollection();
        String idField = query2.getIdProperty();
        if (idField == null) {
            idField = this.entityInformation.getIdAttribute();
        }
        return Query.query(Criteria.where(idField).in(idCollection));
    }
}

