/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.observability.CassandraObservationContext;
import org.springframework.data.cassandra.observability.CassandraObservationConvention;
import org.springframework.data.cassandra.observability.DefaultCassandraObservationConvention;
import org.springframework.data.cassandra.observability.ObservationStatement;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class ObservableReactiveSession
implements ReactiveSession {
    private final ReactiveSession delegate;
    private final String remoteServiceName;
    private final ObservationRegistry observationRegistry;
    private final CassandraObservationConvention convention;

    ObservableReactiveSession(ReactiveSession delegate, String remoteServiceName, CassandraObservationConvention convention, ObservationRegistry observationRegistry) {
        this.delegate = delegate;
        this.remoteServiceName = remoteServiceName;
        this.convention = convention;
        this.observationRegistry = observationRegistry;
    }

    public static ReactiveSession create(ReactiveSession session, ObservationRegistry observationRegistry) {
        return new ObservableReactiveSession(session, "Cassandra", DefaultCassandraObservationConvention.INSTANCE, observationRegistry);
    }

    public static ReactiveSession create(ReactiveSession session, String remoteServiceName, ObservationRegistry observationRegistry) {
        return new ObservableReactiveSession(session, remoteServiceName, DefaultCassandraObservationConvention.INSTANCE, observationRegistry);
    }

    public static ReactiveSession create(ReactiveSession session, String remoteServiceName, CassandraObservationConvention convention, ObservationRegistry observationRegistry) {
        return new ObservableReactiveSession(session, remoteServiceName, convention, observationRegistry);
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public DriverContext getContext() {
        return this.delegate.getContext();
    }

    @Override
    public Optional<CqlIdentifier> getKeyspace() {
        return this.delegate.getKeyspace();
    }

    @Override
    public Metadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public Mono<ReactiveResultSet> execute(String cql) {
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)cql));
    }

    @Override
    public Mono<ReactiveResultSet> execute(String cql, Object ... objects) {
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)cql, (Object[])objects));
    }

    @Override
    public Mono<ReactiveResultSet> execute(String cql, Map<String, Object> map) {
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)cql, map));
    }

    @Override
    public Mono<ReactiveResultSet> execute(Statement<?> statement) {
        if (ObservationStatement.isObservationStatement(statement)) {
            return this.delegate.execute(statement);
        }
        return Mono.deferContextual(contextView -> {
            Observation observation = this.startObservation(ObservableReactiveSession.getParentObservation(contextView), statement, false, "execute");
            return this.delegate.execute(ObservationStatement.createProxy(observation, statement));
        });
    }

    @Override
    public Mono<PreparedStatement> prepare(String cql) {
        return this.prepare(SimpleStatement.newInstance((String)cql));
    }

    @Override
    public Mono<PreparedStatement> prepare(SimpleStatement statement) {
        if (ObservationStatement.isObservationStatement(statement)) {
            return this.delegate.prepare(statement);
        }
        return Mono.deferContextual(contextView -> {
            Observation observation = this.startObservation(ObservableReactiveSession.getParentObservation(contextView), (Statement<?>)statement, true, "prepare");
            return this.delegate.prepare(ObservationStatement.createProxy(observation, statement)).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(ignore -> observation.stop());
        });
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private Observation startObservation(@Nullable Observation parent, Statement<?> statement, boolean prepare, String methodName) {
        Observation observation = Observation.createNotStarted((String)methodName, () -> new CassandraObservationContext(statement, this.remoteServiceName, prepare, methodName, this.delegate.getContext().getSessionName(), this.delegate.getKeyspace().map(CqlIdentifier::asInternal).orElse("system")), (ObservationRegistry)this.observationRegistry).observationConvention((ObservationConvention)this.convention);
        if (parent != null) {
            observation.parentObservation(parent);
        }
        return observation.start();
    }

    @Nullable
    private static Observation getParentObservation(ContextView contextView) {
        return (Observation)contextView.getOrDefault((Object)"micrometer.observation", null);
    }
}

