/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import java.nio.ByteBuffer;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class CassandraScrollPosition
implements ScrollPosition {
    public static CassandraScrollPosition initial() {
        return Initial.INSTANCE;
    }

    public static CassandraScrollPosition of(ByteBuffer pagingState) {
        Assert.notNull((Object)pagingState, (String)"PagingState must not be null");
        return new PagingState(pagingState);
    }

    public abstract ByteBuffer getPagingState();

    static final class Initial
    extends CassandraScrollPosition {
        private static final Initial INSTANCE = new Initial();

        Initial() {
        }

        public boolean isInitial() {
            return true;
        }

        @Override
        public ByteBuffer getPagingState() {
            throw new IllegalStateException("Initial scroll position does not provide a PagingState");
        }
    }

    static final class PagingState
    extends CassandraScrollPosition {
        private final ByteBuffer pagingState;

        PagingState(ByteBuffer pagingState) {
            this.pagingState = pagingState;
        }

        public boolean isInitial() {
            return false;
        }

        @Override
        public ByteBuffer getPagingState() {
            return this.pagingState.asReadOnlyBuffer();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PagingState that = (PagingState)o;
            return ObjectUtils.nullSafeEquals((Object)this.pagingState, (Object)that.pagingState);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.pagingState);
        }
    }
}

