/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraRepositoryQuerySupport;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryExecution;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveCassandraQuery
extends CassandraRepositoryQuerySupport {
    private final ReactiveCassandraOperations operations;

    public AbstractReactiveCassandraQuery(ReactiveCassandraQueryMethod method, ReactiveCassandraOperations operations) {
        super(method, (MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)operations.getConverter().getMappingContext());
        this.operations = operations;
    }

    @Override
    public ReactiveCassandraQueryMethod getQueryMethod() {
        return (ReactiveCassandraQueryMethod)super.getQueryMethod();
    }

    public Object execute(Object[] parameters) {
        ReactiveCassandraParameterAccessor parameterAccessor = new ReactiveCassandraParameterAccessor(this.getQueryMethod(), parameters);
        Mono<ReactiveCassandraParameterAccessor> resolved = parameterAccessor.resolveParameters();
        return resolved.flatMapMany(this::executeLater);
    }

    private Publisher<Object> executeLater(ReactiveCassandraParameterAccessor parameterAccessor) {
        Mono<SimpleStatement> statement = this.createQuery(parameterAccessor);
        ResultProcessor resultProcessor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        ReactiveCassandraQueryExecution queryExecution = this.getExecution(parameterAccessor, new ReactiveCassandraQueryExecution.ResultProcessingConverter(resultProcessor, this.getMappingContext(), this.getEntityInstantiators()));
        Class<?> resultType = this.resolveResultType(resultProcessor);
        return statement.flatMapMany(it -> queryExecution.execute((Statement<?>)it, resultType));
    }

    private Class<?> resolveResultType(ResultProcessor resultProcessor) {
        CassandraRepositoryQuerySupport.CassandraReturnedType returnedType = new CassandraRepositoryQuerySupport.CassandraReturnedType(this, resultProcessor.getReturnedType(), this.getReactiveCassandraOperations().getConverter().getCustomConversions());
        return returnedType.getResultType();
    }

    protected abstract Mono<SimpleStatement> createQuery(CassandraParameterAccessor var1);

    protected ReactiveCassandraOperations getReactiveCassandraOperations() {
        return this.operations;
    }

    private ReactiveCassandraQueryExecution getExecution(ReactiveCassandraParameterAccessor parameterAccessor, Converter<Object, Object> resultProcessing) {
        return new ReactiveCassandraQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(parameterAccessor), resultProcessing);
    }

    private ReactiveCassandraQueryExecution getExecutionToWrap(CassandraParameterAccessor parameterAccessor) {
        if (this.getQueryMethod().isSliceQuery()) {
            return new ReactiveCassandraQueryExecution.SlicedExecution(this.getReactiveCassandraOperations(), parameterAccessor.getPageable());
        }
        if (this.getQueryMethod().isScrollQuery()) {
            return new ReactiveCassandraQueryExecution.WindowExecution(this.getReactiveCassandraOperations(), parameterAccessor.getScrollPosition(), parameterAccessor.getLimit());
        }
        if (this.getQueryMethod().isCollectionQuery()) {
            return new ReactiveCassandraQueryExecution.CollectionExecution(this.getReactiveCassandraOperations());
        }
        if (this.isCountQuery()) {
            return (statement, type) -> new ReactiveCassandraQueryExecution.SingleEntityExecution(this.getReactiveCassandraOperations(), false).execute(statement, Long.class);
        }
        if (this.isExistsQuery()) {
            return new ReactiveCassandraQueryExecution.ExistsExecution(this.getReactiveCassandraOperations());
        }
        if (this.isModifyingQuery()) {
            return (statement, type) -> this.getReactiveCassandraOperations().execute(statement).map(ReactiveResultSet::wasApplied);
        }
        return new ReactiveCassandraQueryExecution.SingleEntityExecution(this.getReactiveCassandraOperations(), this.isLimiting());
    }

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isLimiting();

    protected abstract boolean isModifyingQuery();
}

