/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import java.time.Duration;
import java.util.function.BiFunction;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.util.Bindings;
import org.springframework.util.Assert;

public abstract class QueryOptionsUtil {
    public static <T extends Statement<?>> T addQueryOptions(T statement, QueryOptions queryOptions) {
        Assert.notNull(statement, (String)"Statement must not be null");
        Object statementToUse = statement;
        if (queryOptions.getConsistencyLevel() != null) {
            statementToUse = statementToUse.setConsistencyLevel(queryOptions.getConsistencyLevel());
        }
        statementToUse = queryOptions.getExecutionProfileResolver().apply((Statement<?>)statementToUse);
        if (queryOptions.isIdempotent() != null) {
            statementToUse = statementToUse.setIdempotent(queryOptions.isIdempotent());
        }
        if (queryOptions.getPageSize() != null) {
            statementToUse = statementToUse.setPageSize(queryOptions.getPageSize().intValue());
        }
        if (queryOptions.getRoutingKeyspace() != null) {
            statementToUse = statementToUse.setRoutingKeyspace(queryOptions.getRoutingKeyspace());
        }
        if (queryOptions.getRoutingKey() != null) {
            statementToUse = statement.setRoutingKey(queryOptions.getRoutingKey());
        }
        if (queryOptions.getSerialConsistencyLevel() != null) {
            statementToUse = statementToUse.setSerialConsistencyLevel(queryOptions.getSerialConsistencyLevel());
        }
        if (!queryOptions.getTimeout().isNegative()) {
            statementToUse = statementToUse.setTimeout(queryOptions.getTimeout());
        }
        if (queryOptions.getTracing() != null) {
            statementToUse = statementToUse.setTracing(Boolean.TRUE.equals(queryOptions.getTracing()));
        }
        if (queryOptions.getKeyspace() != null) {
            if (statementToUse instanceof BoundStatement) {
                throw new IllegalArgumentException("Keyspace cannot be set for a BoundStatement");
            }
            if (statementToUse instanceof BatchStatement) {
                statementToUse = ((BatchStatement)statementToUse).setKeyspace(queryOptions.getKeyspace());
            }
            if (statementToUse instanceof SimpleStatement) {
                statementToUse = ((SimpleStatement)statementToUse).setKeyspace(queryOptions.getKeyspace());
            }
        }
        return statementToUse;
    }

    public static Insert addWriteOptions(Insert insert, WriteOptions writeOptions) {
        Assert.notNull((Object)insert, (String)"Insert must not be null");
        Assert.notNull((Object)writeOptions, (String)"WriteOptions must not be null");
        Insert insertToUse = insert;
        if (writeOptions.getTimestamp() != null) {
            insertToUse = insertToUse.usingTimestamp(writeOptions.getTimestamp().longValue());
        }
        if (QueryOptionsUtil.hasTtl(writeOptions.getTtl())) {
            insertToUse = insertToUse.usingTtl(Math.toIntExact(writeOptions.getTtl().getSeconds()));
        }
        return insertToUse;
    }

    public static Update addWriteOptions(Update update, WriteOptions writeOptions) {
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull((Object)writeOptions, (String)"WriteOptions must not be null");
        if (writeOptions.getTimestamp() != null) {
            update = (Update)((UpdateStart)update).usingTimestamp(writeOptions.getTimestamp().longValue());
        }
        if (QueryOptionsUtil.hasTtl(writeOptions.getTtl())) {
            update = (Update)((UpdateStart)update).usingTtl(QueryOptionsUtil.getTtlSeconds(writeOptions.getTtl()));
        }
        return update;
    }

    public static Delete addWriteOptions(Delete delete, WriteOptions writeOptions) {
        Assert.notNull((Object)delete, (String)"Delete must not be null");
        Assert.notNull((Object)writeOptions, (String)"WriteOptions must not be null");
        if (writeOptions.getTimestamp() != null) {
            delete = (Delete)((DeleteSelection)delete).usingTimestamp(writeOptions.getTimestamp().longValue());
        }
        return delete;
    }

    public static <T> T addWriteOptions(CqlStatementOptionsAccessor<T> accessor, WriteOptions writeOptions) {
        Assert.notNull(accessor, (String)"CqlStatementOptionsAccessor must not be null");
        Assert.notNull((Object)writeOptions, (String)"WriteOptions must not be null");
        if (writeOptions.getTimestamp() != null) {
            accessor.usingTimestamp(writeOptions.getTimestamp());
        }
        if (QueryOptionsUtil.hasTtl(writeOptions.getTtl())) {
            accessor.usingTtl(QueryOptionsUtil.getTtlSeconds(writeOptions.getTtl()));
        }
        return accessor.getStatement();
    }

    private static int getTtlSeconds(Duration ttl) {
        return Math.toIntExact(ttl.getSeconds());
    }

    private static boolean hasTtl(Duration ttl) {
        return !ttl.isZero() && !ttl.isNegative();
    }

    public static abstract class CqlStatementOptionsAccessor<T> {
        abstract void usingTimestamp(long var1);

        abstract void usingTtl(int var1);

        abstract T getStatement();

        public static CqlStatementOptionsAccessor<Insert> ofInsert(Bindings bindings, Insert statement) {
            return new BoundOptionsAccessor<Insert>(bindings, statement, Insert::usingTimestamp, Insert::usingTtl);
        }

        public static CqlStatementOptionsAccessor<Insert> ofInsert(Insert statement) {
            return new InlineOptionsAccessor<Insert>(statement, Insert::usingTimestamp, Insert::usingTtl);
        }

        public static CqlStatementOptionsAccessor<UpdateStart> ofUpdate(Bindings bindings, UpdateStart statement) {
            return new BoundOptionsAccessor<UpdateStart>(bindings, statement, UpdateStart::usingTimestamp, UpdateStart::usingTtl);
        }

        public static CqlStatementOptionsAccessor<UpdateStart> ofUpdate(UpdateStart statement) {
            return new InlineOptionsAccessor<UpdateStart>(statement, UpdateStart::usingTimestamp, UpdateStart::usingTtl);
        }

        public static CqlStatementOptionsAccessor<DeleteSelection> ofDelete(Bindings bindings, DeleteSelection statement) {
            return new BoundOptionsAccessor<DeleteSelection>(bindings, statement, DeleteSelection::usingTimestamp, (deleteSelection, bindMarker) -> deleteSelection);
        }

        public static CqlStatementOptionsAccessor<DeleteSelection> ofDelete(DeleteSelection statement) {
            return new InlineOptionsAccessor<DeleteSelection>(statement, DeleteSelection::usingTimestamp, (deleteSelection, bindMarker) -> deleteSelection);
        }
    }

    private static class InlineOptionsAccessor<T>
    extends CqlStatementOptionsAccessor<T> {
        private T instance;
        private final TimestampFunction<T> timestampFunction;
        private final TtlFunction<T> ttlFunction;

        private InlineOptionsAccessor(T instance, TimestampFunction<T> timestampFunction, TtlFunction<T> ttlFunction) {
            this.instance = instance;
            this.timestampFunction = timestampFunction;
            this.ttlFunction = ttlFunction;
        }

        @Override
        void usingTimestamp(long timestamp) {
            this.instance = this.timestampFunction.apply(this.instance, timestamp);
        }

        @Override
        void usingTtl(int ttl) {
            this.instance = this.ttlFunction.apply(this.instance, ttl);
        }

        @Override
        T getStatement() {
            return this.instance;
        }

        static interface TimestampFunction<T> {
            public T apply(T var1, long var2);
        }

        static interface TtlFunction<T> {
            public T apply(T var1, int var2);
        }
    }

    private static class BoundOptionsAccessor<T>
    extends CqlStatementOptionsAccessor<T> {
        private final Bindings bindings;
        private T instance;
        private final BiFunction<T, BindMarker, T> timestampFunction;
        private final BiFunction<T, BindMarker, T> ttlFunction;

        private BoundOptionsAccessor(Bindings bindings, T instance, BiFunction<T, BindMarker, T> timestampFunction, BiFunction<T, BindMarker, T> ttlFunction) {
            this.bindings = bindings;
            this.instance = instance;
            this.timestampFunction = timestampFunction;
            this.ttlFunction = ttlFunction;
        }

        @Override
        void usingTimestamp(long timestamp) {
            BindMarker bindMarker = this.bindings.bind(timestamp);
            this.instance = this.timestampFunction.apply(this.instance, bindMarker);
        }

        @Override
        void usingTtl(int ttl) {
            BindMarker bindMarker = this.bindings.bind(ttl);
            this.instance = this.ttlFunction.apply(this.instance, bindMarker);
        }

        @Override
        T getStatement() {
            return this.instance;
        }
    }
}

