/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.core.cql.session.DefaultBridgedReactiveSession;
import org.springframework.data.cassandra.observability.CassandraObservationConvention;
import org.springframework.data.cassandra.observability.DefaultCassandraObservationConvention;
import org.springframework.data.cassandra.observability.ObservableReactiveSessionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ObservableReactiveSessionFactoryBean
extends AbstractFactoryBean<ReactiveSession> {
    private final CqlSession cqlSession;
    private final boolean requiresDestroy;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private String remoteServiceName;
    private CassandraObservationConvention convention = DefaultCassandraObservationConvention.INSTANCE;

    public ObservableReactiveSessionFactoryBean(CqlSessionBuilder cqlSessionBuilder, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)cqlSessionBuilder, (String)"CqlSessionBuilder must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.cqlSession = (CqlSession)cqlSessionBuilder.build();
        this.requiresDestroy = true;
        this.observationRegistry = observationRegistry;
    }

    public ObservableReactiveSessionFactoryBean(CqlSession cqlSession, ObservationRegistry observationRegistry) {
        CqlSession cqlSession2;
        Assert.notNull((Object)cqlSession, (String)"CqlSession must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        if (cqlSession instanceof TargetSource) {
            TargetSource c = (TargetSource)cqlSession;
            cqlSession2 = (CqlSession)AopProxyUtils.getSingletonTarget((Object)c);
        } else {
            cqlSession2 = cqlSession;
        }
        this.cqlSession = cqlSession2;
        this.requiresDestroy = false;
        this.observationRegistry = observationRegistry;
    }

    @Nullable
    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setRemoteServiceName(@Nullable String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
    }

    public void setConvention(CassandraObservationConvention convention) {
        this.convention = convention;
    }

    protected ReactiveSession createInstance() {
        String remoteServiceName = ObjectUtils.isEmpty((Object)this.getRemoteServiceName()) ? "Cassandra" : this.getRemoteServiceName();
        return ObservableReactiveSessionFactory.wrap(new DefaultBridgedReactiveSession(this.cqlSession), remoteServiceName, this.convention, this.observationRegistry);
    }

    public Class<?> getObjectType() {
        return ReactiveSession.class;
    }

    public void destroy() {
        if (this.requiresDestroy) {
            this.cqlSession.close();
        }
    }
}

