/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.metadata.Node;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.springframework.util.Assert;

public final class RingMember
implements Serializable {
    private static final long serialVersionUID = -2582309141903132916L;
    private final String hostName;
    private final String address;
    private final String dc;
    private final String rack;

    public static RingMember from(Node host) {
        return new RingMember(host);
    }

    private RingMember(Node host) {
        Assert.notNull((Object)host, (String)"Host must not be null");
        this.hostName = host.getListenAddress().map(InetSocketAddress::getHostName).orElse("unknown");
        this.address = host.getListenAddress().map(InetSocketAddress::getAddress).map(InetAddress::getHostAddress).orElse("unknown");
        this.dc = host.getDatacenter();
        this.rack = host.getRack();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getDataCenter() {
        return this.dc;
    }

    public String getRack() {
        return this.rack;
    }
}

