/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

class DefaultColumnType
implements ColumnType {
    public static final DefaultColumnType OBJECT = new DefaultColumnType(TypeInformation.OBJECT, new ColumnType[0]);
    private final TypeInformation<?> typeInformation;
    private final List<ColumnType> parameters;

    DefaultColumnType(TypeInformation<?> typeInformation, ColumnType ... parameters) {
        this.typeInformation = typeInformation;
        this.parameters = Arrays.asList(parameters);
    }

    List<ColumnType> getParameters() {
        return this.parameters;
    }

    @Override
    public Class<?> getType() {
        return this.typeInformation.getType();
    }

    @Override
    public boolean isCollectionLike() {
        return this.typeInformation.isCollectionLike();
    }

    @Override
    public boolean isList() {
        return List.class.isAssignableFrom(this.typeInformation.getType());
    }

    @Override
    public boolean isSet() {
        return Set.class.isAssignableFrom(this.typeInformation.getType());
    }

    @Override
    public boolean isMap() {
        return this.typeInformation.isMap();
    }

    @Override
    @Nullable
    public ColumnType getComponentType() {
        return !this.parameters.isEmpty() ? this.parameters.get(0) : null;
    }

    @Override
    @Nullable
    public ColumnType getMapValueType() {
        return this.parameters.size() > 1 ? this.parameters.get(1) : null;
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return this.getType().getName();
        }
        return String.format("%s<%s>", this.getType().getName(), this.parameters.stream().map(Object::toString).collect(Collectors.toList()));
    }
}

