/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlSession;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraTemplateFactoryBean
implements FactoryBean<CassandraTemplate>,
InitializingBean {
    @Nullable
    protected SessionFactory sessionFactory;
    @Nullable
    protected CqlOperations cqlOperations;
    @Nullable
    protected CassandraConverter converter;

    public void afterPropertiesSet() throws Exception {
        if (this.cqlOperations == null && this.sessionFactory == null) {
            throw new IllegalArgumentException("Either Session/SessionFactory or CqlOperations must be set");
        }
        if (this.converter == null) {
            this.converter = new MappingCassandraConverter();
        }
    }

    public CassandraTemplate getObject() throws Exception {
        if (this.cqlOperations != null) {
            return new CassandraTemplate(this.cqlOperations, this.converter);
        }
        return new CassandraTemplate(this.sessionFactory, this.converter);
    }

    public Class<CassandraTemplate> getObjectType() {
        return CassandraTemplate.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setSession(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.setSessionFactory(new DefaultSessionFactory(session));
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    public void setCqlOperations(CqlOperations cqlOperations) {
        Assert.notNull((Object)cqlOperations, (String)"CqlOperations must not be null");
        this.cqlOperations = cqlOperations;
    }

    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"Converter must not be null");
        this.converter = converter;
    }
}

