/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import org.springframework.util.Assert;

public class FieldSpecification {
    private final CqlIdentifier name;
    private final DataType type;

    private FieldSpecification(CqlIdentifier name, DataType type) {
        Assert.notNull((Object)name, (String)"CqlIdentifier must not be null");
        Assert.notNull((Object)type, (String)"DataType must not be null");
        this.name = name;
        this.type = type;
    }

    public static FieldSpecification of(String name, DataType type) {
        return new FieldSpecification(CqlIdentifier.fromCql((String)name), type);
    }

    public static FieldSpecification of(CqlIdentifier name, DataType type) {
        return new FieldSpecification(name, type);
    }

    public String toCql() {
        return this.toCql(new StringBuilder()).toString();
    }

    public StringBuilder toCql(StringBuilder cql) {
        return cql.append(this.name.asCql(true)).append(" ").append(this.type.asCql(true, true));
    }

    public String toString() {
        return this.toCql(new StringBuilder()).toString();
    }
}

