/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.StringJoiner;
import org.springframework.data.cassandra.observability.CassandraObservation;
import org.springframework.data.cassandra.observability.CassandraObservationContext;
import org.springframework.data.cassandra.observability.CassandraObservationConvention;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class DefaultCassandraObservationConvention
implements CassandraObservationConvention {
    DefaultCassandraObservationConvention() {
    }

    public KeyValues getLowCardinalityKeyValues(CassandraObservationContext context) {
        String dbOperation = context.isPrepare() ? "PREPARE" : this.getOperationName(DefaultCassandraObservationConvention.getCql(context.getStatement()), "");
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{CassandraObservation.LowCardinalityKeyNames.DATABASE_SYSTEM.withValue("cassandra"), CassandraObservation.LowCardinalityKeyNames.KEYSPACE_NAME.withValue(context.getKeyspaceName()), CassandraObservation.LowCardinalityKeyNames.SESSION_NAME.withValue(context.getSessionName()), CassandraObservation.LowCardinalityKeyNames.METHOD_NAME.withValue(context.getMethodName()), CassandraObservation.LowCardinalityKeyNames.DB_OPERATION.withValue(dbOperation)});
        Node node = context.getNode();
        if (node == null) {
            node = context.getStatement().getNode();
        }
        if (node != null) {
            EndPoint endPoint = node.getEndPoint();
            keyValues = keyValues.and(new KeyValue[]{CassandraObservation.LowCardinalityKeyNames.COORDINATOR.withValue("" + node.getHostId()), CassandraObservation.LowCardinalityKeyNames.COORDINATOR_DC.withValue(node.getDatacenter())});
            keyValues.and(new KeyValue[]{CassandraObservation.LowCardinalityKeyNames.NET_PEER_NAME.withValue(endPoint.toString())});
            InetSocketAddress socketAddress = this.tryGetSocketAddress(endPoint);
            if (socketAddress != null) {
                keyValues = keyValues.and(new KeyValue[]{CassandraObservation.LowCardinalityKeyNames.NET_TRANSPORT.withValue("IP.TCP"), CassandraObservation.LowCardinalityKeyNames.NET_SOCK_PEER_ADDR.withValue(socketAddress.getHostString()), CassandraObservation.LowCardinalityKeyNames.NET_SOCK_PEER_PORT.withValue("" + socketAddress.getPort())});
            }
        }
        return keyValues;
    }

    public KeyValues getHighCardinalityKeyValues(CassandraObservationContext context) {
        ConsistencyLevel consistencyLevel;
        Statement<?> statement = context.getStatement();
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{CassandraObservation.HighCardinalityKeyNames.DB_STATEMENT.withValue(DefaultCassandraObservationConvention.getCql(statement)), CassandraObservation.HighCardinalityKeyNames.PAGE_SIZE.withValue("" + statement.getPageSize())});
        Boolean idempotent = statement.isIdempotent();
        if (idempotent != null) {
            keyValues = keyValues.and(new KeyValue[]{CassandraObservation.HighCardinalityKeyNames.IDEMPOTENCE.withValue(idempotent != false ? "idempotent" : "non-idempotent")});
        }
        if ((consistencyLevel = statement.getConsistencyLevel()) != null) {
            keyValues = keyValues.and(new KeyValue[]{CassandraObservation.HighCardinalityKeyNames.CONSISTENCY_LEVEL.withValue(consistencyLevel.name())});
        }
        return keyValues;
    }

    @Nullable
    private InetSocketAddress tryGetSocketAddress(EndPoint endPoint) {
        try {
            SocketAddress socketAddress = endPoint.resolve();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inet = (InetSocketAddress)socketAddress;
                return inet;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public String getContextualName(CassandraObservationContext context) {
        return (context.isPrepare() ? "PREPARE: " : "") + this.getOperationName(DefaultCassandraObservationConvention.getCql(context.getStatement()), "");
    }

    private static String getCql(Statement<?> statement) {
        String query2 = "";
        if (statement instanceof SimpleStatement || statement instanceof BoundStatement) {
            query2 = DefaultCassandraObservationConvention.getQuery(statement);
        }
        if (statement instanceof BatchStatement) {
            StringJoiner joiner = new StringJoiner(";");
            for (BatchableStatement bs : (BatchStatement)statement) {
                joiner.add(DefaultCassandraObservationConvention.getQuery(bs));
            }
            query2 = joiner.toString();
        }
        return query2;
    }

    private static String getQuery(Statement<?> statement) {
        if (statement instanceof SimpleStatement) {
            return ((SimpleStatement)statement).getQuery();
        }
        if (statement instanceof BoundStatement) {
            return ((BoundStatement)statement).getPreparedStatement().getQuery();
        }
        return "";
    }

    public String getOperationName(String cql, String defaultName) {
        if (StringUtils.hasText((String)cql) && cql.indexOf(32) > -1) {
            return cql.substring(0, cql.indexOf(32));
        }
        return defaultName;
    }
}

