/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.legacy;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collector;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

@Deprecated(since="4.0", forRemoval=true)
class AsyncResultStream<T> {
    private final AsyncResultSet resultSet;
    private final RowMapper<T> mapper;

    private AsyncResultStream(AsyncResultSet resultSet, RowMapper<T> mapper) {
        this.resultSet = resultSet;
        this.mapper = mapper;
    }

    static AsyncResultStream<Row> from(AsyncResultSet resultSet) {
        Assert.notNull((Object)resultSet, (String)"AsyncResultSet must not be null");
        return new AsyncResultStream<Row>(resultSet, (row, rowNum) -> row);
    }

    <R> AsyncResultStream<R> map(RowMapper<R> mapper) {
        Assert.notNull(mapper, (String)"RowMapper must not be null");
        return new AsyncResultStream<R>(this.resultSet, mapper);
    }

    <R, A> ListenableFuture<R> collect(Collector<? super T, A, R> collector) {
        Assert.notNull(collector, (String)"Collector must not be null");
        SettableListenableFuture future = new SettableListenableFuture();
        CollectState<A, R> collectState = new CollectState<A, R>(collector);
        collectState.collectAsync(future, this.resultSet);
        return future;
    }

    ListenableFuture<Void> forEach(Consumer<T> action) {
        Assert.notNull(action, (String)"Action must not be null");
        SettableListenableFuture future = new SettableListenableFuture();
        ForwardLoopState loopState = new ForwardLoopState(action);
        loopState.forEachAsync((SettableListenableFuture<Void>)future, this.resultSet);
        return future;
    }

    class CollectState<A, R> {
        private final AtomicInteger rowNumber = new AtomicInteger();
        private volatile A intermediate;
        private final Collector<? super T, A, R> collector;

        CollectState(Collector<? super T, A, R> collector) {
            this.collector = collector;
            this.intermediate = collector.supplier().get();
        }

        void collectPage(Iterable<Row> rows) {
            for (Row row : rows) {
                this.collector.accumulator().accept(this.intermediate, AsyncResultStream.this.mapper.mapRow(row, this.rowNumber.incrementAndGet()));
            }
        }

        R finish() {
            return this.collector.finisher().apply(this.intermediate);
        }

        void collectAsync(SettableListenableFuture<R> target, AsyncResultSet resultSet) {
            if (target.isCancelled()) {
                return;
            }
            try {
                this.collectPage(resultSet.currentPage());
            }
            catch (RuntimeException e) {
                target.setException((Throwable)e);
                return;
            }
            if (!resultSet.hasMorePages()) {
                target.set(this.finish());
            } else {
                CompletionStage nextPage = resultSet.fetchNextPage();
                nextPage.whenComplete((nextResultSet, throwable) -> {
                    if (throwable != null) {
                        target.setException(throwable);
                    } else {
                        this.collectAsync(target, (AsyncResultSet)nextResultSet);
                    }
                });
            }
        }
    }

    class ForwardLoopState {
        private final AtomicInteger rowNumber = new AtomicInteger();
        private final Consumer<T> consumer;

        ForwardLoopState(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        void peekRow(Iterable<Row> rows) {
            rows.forEach(row -> this.consumer.accept(AsyncResultStream.this.mapper.mapRow((Row)row, this.rowNumber.incrementAndGet())));
        }

        void forEachAsync(SettableListenableFuture<Void> target, AsyncResultSet resultSet) {
            if (target.isCancelled()) {
                return;
            }
            try {
                this.peekRow(resultSet.currentPage());
            }
            catch (RuntimeException e) {
                target.setException((Throwable)e);
                return;
            }
            if (!resultSet.hasMorePages()) {
                target.set(null);
            } else {
                CompletionStage nextPage = resultSet.fetchNextPage();
                nextPage.whenComplete((nextResultSet, throwable) -> {
                    if (throwable != null) {
                        target.setException(throwable);
                    } else {
                        this.forEachAsync(target, (AsyncResultSet)nextResultSet);
                    }
                });
            }
        }
    }
}

