/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class QueryExtractorDelegate {
    @Nullable
    public static String getCql(@Nullable Object statement) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof CqlProvider) {
            return ((CqlProvider)statement).getCql();
        }
        if (statement instanceof SimpleStatement) {
            return ((SimpleStatement)statement).getQuery();
        }
        if (statement instanceof PreparedStatement) {
            return ((PreparedStatement)statement).getQuery();
        }
        if (statement instanceof BoundStatement) {
            return QueryExtractorDelegate.getCql(((BoundStatement)statement).getPreparedStatement());
        }
        if (statement instanceof BatchStatement) {
            StringBuilder builder = new StringBuilder();
            for (BatchableStatement batchableStatement : (BatchStatement)statement) {
                String query2 = QueryExtractorDelegate.getCql(batchableStatement);
                builder.append(query2);
                if (ObjectUtils.isEmpty((Object)query2)) continue;
                builder.append(query2.endsWith(";") ? "" : ";");
            }
            return builder.toString();
        }
        return "Unknown: " + statement;
    }
}

