/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.List;
import org.springframework.data.cassandra.core.WriteResult;

public class EntityWriteResult<T>
extends WriteResult {
    private final T entity;

    EntityWriteResult(List<ExecutionInfo> executionInfo, boolean wasApplied, List<Row> rows, T entity) {
        super(executionInfo, wasApplied, rows);
        this.entity = entity;
    }

    EntityWriteResult(ResultSet resultSet, T entity) {
        super(resultSet);
        this.entity = entity;
    }

    static <T> EntityWriteResult<T> of(WriteResult result, T entity) {
        return new EntityWriteResult<T>(result.getExecutionInfo(), result.wasApplied(), result.getRows(), entity);
    }

    static <T> EntityWriteResult<T> of(ResultSet resultSet, T entity) {
        return new EntityWriteResult<T>(resultSet, entity);
    }

    public T getEntity() {
        return this.entity;
    }
}

