/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;

@Deprecated
public abstract class CassandraJodaTimeConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", null);

    private CassandraJodaTimeConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JODA_TIME_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(MillisOfDayToLocalTimeConverter.INSTANCE);
        converters.add(FromJodaLocalTimeConverter.INSTANCE);
        converters.add(ToJodaLocalTimeConverter.INSTANCE);
        converters.add(FromJodaLocalDateConverter.INSTANCE);
        converters.add(ToJodaLocalDateConverter.INSTANCE);
        converters.add(LocalDateTimeToInstantConverter.INSTANCE);
        converters.add(InstantToLocalDateTimeConverter.INSTANCE);
        converters.add(DateTimeToInstantConverter.INSTANCE);
        converters.add(InstantToDateTimeConverter.INSTANCE);
        return converters;
    }

    @Deprecated
    public static enum InstantToDateTimeConverter implements Converter<Instant, DateTime>
    {
        INSTANCE;


        public DateTime convert(Instant source) {
            return new DateTime((Object)Date.from(source));
        }
    }

    @Deprecated
    public static enum DateTimeToInstantConverter implements Converter<DateTime, Instant>
    {
        INSTANCE;


        public Instant convert(DateTime source) {
            return source.toDate().toInstant();
        }
    }

    @Deprecated
    public static enum InstantToLocalDateTimeConverter implements Converter<Instant, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Instant source) {
            return new LocalDateTime((Object)Date.from(source));
        }
    }

    @Deprecated
    public static enum LocalDateTimeToInstantConverter implements Converter<LocalDateTime, Instant>
    {
        INSTANCE;


        public Instant convert(LocalDateTime source) {
            return source.toDate().toInstant();
        }
    }

    @Deprecated
    public static enum ToJodaLocalDateConverter implements Converter<LocalDate, org.joda.time.LocalDate>
    {
        INSTANCE;


        public org.joda.time.LocalDate convert(LocalDate date) {
            return new org.joda.time.LocalDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        }
    }

    @WritingConverter
    @Deprecated
    public static enum FromJodaLocalDateConverter implements Converter<org.joda.time.LocalDate, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(org.joda.time.LocalDate date) {
            return LocalDate.of(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
        }
    }

    @Deprecated
    public static enum ToJodaLocalTimeConverter implements Converter<java.time.LocalTime, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(java.time.LocalTime source) {
            return LocalTime.fromMillisOfDay((long)TimeUnit.NANOSECONDS.toMillis(source.toNanoOfDay()));
        }
    }

    @WritingConverter
    @Deprecated
    public static enum FromJodaLocalTimeConverter implements Converter<LocalTime, java.time.LocalTime>
    {
        INSTANCE;


        public java.time.LocalTime convert(LocalTime source) {
            return java.time.LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(source.getMillisOfDay()));
        }
    }

    @Deprecated
    public static enum LocalTimeToMillisOfDayConverter implements Converter<LocalTime, Long>
    {
        INSTANCE;


        public Long convert(LocalTime source) {
            return source.getMillisOfDay();
        }
    }

    @Deprecated
    public static enum MillisOfDayToLocalTimeConverter implements Converter<Long, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(Long source) {
            return LocalTime.fromMillisOfDay((long)source);
        }
    }
}

