/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.cassandra.config.CassandraEntityClassScanner;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.EntityMapping;
import org.springframework.data.cassandra.core.mapping.Mapping;
import org.springframework.data.cassandra.core.mapping.PropertyMapping;
import org.springframework.data.cassandra.core.mapping.SimpleUserTypeResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class CassandraMappingContextParser
extends AbstractSingleBeanDefinitionParser {
    CassandraMappingContextParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return CassandraMappingContext.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraMapping";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.parseMapping(element, builder);
        builder.getRawBeanDefinition().setSource((Object)element);
    }

    private void parseMapping(Element element, BeanDefinitionBuilder builder) {
        String packages = element.getAttribute("entity-base-packages");
        if (StringUtils.hasText((String)packages)) {
            try {
                Set<Class<?>> entityClasses = CassandraEntityClassScanner.scan(StringUtils.commaDelimitedListToStringArray((String)packages));
                builder.addPropertyValue("initialEntitySet", entityClasses);
            }
            catch (Exception x) {
                throw new IllegalArgumentException(String.format("encountered exception while scanning for entity classes in package(s) [%s]", packages), x);
            }
        }
        HashSet<EntityMapping> mappings = new HashSet<EntityMapping>();
        DomUtils.getChildElementsByTagName((Element)element, (String)"entity").forEach(entity -> {
            EntityMapping entityMapping = this.parseEntity((Element)entity);
            mappings.add(entityMapping);
        });
        List userTypeResolvers = DomUtils.getChildElementsByTagName((Element)element, (String)"user-type-resolver");
        String userTypeResolverRef = element.getAttribute("user-type-resolver-ref");
        if (StringUtils.hasText((String)userTypeResolverRef)) {
            Assert.isTrue((boolean)userTypeResolvers.isEmpty(), (String)"Must not define user-type-resolver and user-type-resolver-ref");
            builder.addPropertyReference("userTypeResolver", userTypeResolverRef);
        }
        if (!userTypeResolvers.isEmpty()) {
            BeanDefinition userTypeResolver = this.parseUserTypeResolver((Element)userTypeResolvers.get(0));
            builder.addPropertyValue("userTypeResolver", (Object)userTypeResolver);
        }
        Mapping mapping = new Mapping();
        mapping.setEntityMappings(mappings);
        builder.addPropertyValue("mapping", (Object)mapping);
    }

    private EntityMapping parseEntity(Element entity) {
        String className = entity.getAttribute("class");
        Assert.state((boolean)StringUtils.hasText((String)className), (String)"class attribute must not be empty");
        Element table = DomUtils.getChildElementByTagName((Element)entity, (String)"table");
        String tableName = "";
        String forceQuote = "";
        if (table != null) {
            tableName = table.getAttribute("name");
            tableName = StringUtils.hasText((String)tableName) ? tableName : "";
            forceQuote = String.valueOf(Boolean.parseBoolean(table.getAttribute("force-quote")));
        }
        Map<String, PropertyMapping> propertyMappings = this.parsePropertyMappings(entity);
        EntityMapping entityMapping = new EntityMapping(className, tableName, forceQuote);
        entityMapping.setPropertyMappings(propertyMappings);
        return entityMapping;
    }

    private BeanDefinition parseUserTypeResolver(Element entity) {
        String sessionRef = entity.getAttribute("session-ref");
        if (StringUtils.hasText((String)sessionRef)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SimpleUserTypeResolver.class);
            builder.addConstructorArgReference(sessionRef);
            return builder.getBeanDefinition();
        }
        String keyspaceName = entity.getAttribute("keyspace-name");
        Assert.state((boolean)StringUtils.hasText((String)keyspaceName), (String)"keyspace-name attribute must not be null or empty");
        String clusterRef = entity.getAttribute("cluster-ref");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SimpleUserTypeResolver.class);
        builder.addConstructorArgReference(StringUtils.hasText((String)clusterRef) ? clusterRef : "cassandraCluster");
        builder.addConstructorArgValue((Object)keyspaceName);
        return builder.getBeanDefinition();
    }

    private Map<String, PropertyMapping> parsePropertyMappings(Element entity) {
        HashMap<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>();
        for (Element property : DomUtils.getChildElementsByTagName((Element)entity, (String)"property")) {
            String value = property.getAttribute("name");
            Assert.state((boolean)StringUtils.hasText((String)value), (String)"name attribute must not be empty");
            PropertyMapping propertyMapping = new PropertyMapping(value);
            value = property.getAttribute("column-name");
            if (StringUtils.hasText((String)value)) {
                propertyMapping.setColumnName(value);
            }
            if (StringUtils.hasText((String)(value = property.getAttribute("force-quote")))) {
                propertyMapping.setForceQuote(value);
            }
            propertyMappings.put(propertyMapping.getPropertyName(), propertyMapping);
        }
        return propertyMappings;
    }
}

