/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataType;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.util.StringUtils;

class PreparedStatementDelegate {
    PreparedStatementDelegate() {
    }

    static BoundStatement bind(SimpleStatement statement, PreparedStatement ps) {
        BoundStatementBuilder boundStatementBuilder = ps.boundStatementBuilder(statement.getPositionalValues().toArray());
        Map namedValues = statement.getNamedValues();
        ColumnDefinitions variableDefinitions = ps.getVariableDefinitions();
        for (Map.Entry entry : namedValues.entrySet()) {
            if (entry.getValue() == null) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.setToNull((CqlIdentifier)entry.getKey());
                continue;
            }
            DataType type = variableDefinitions.get((CqlIdentifier)entry.getKey()).getType();
            boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set((CqlIdentifier)entry.getKey(), entry.getValue(), boundStatementBuilder.codecRegistry().codecFor(type));
        }
        return ps.bind(statement.getPositionalValues().toArray());
    }

    static SimpleStatement getStatementForPrepare(Statement<?> statement) {
        if (statement instanceof SimpleStatement) {
            return (SimpleStatement)statement;
        }
        throw new IllegalArgumentException(PreparedStatementDelegate.getMessage(statement));
    }

    static boolean canPrepare(boolean usePreparedStatements, Statement<?> statement, Logger logger) {
        if (usePreparedStatements) {
            if (statement instanceof SimpleStatement) {
                return true;
            }
            logger.warn(PreparedStatementDelegate.getMessage(statement));
        }
        return false;
    }

    private static String getMessage(Statement<?> statement) {
        String cql = QueryExtractorDelegate.getCql(statement);
        if (StringUtils.hasText((String)cql)) {
            return String.format("Cannot prepare statement %s (%s). Statement must be a SimpleStatement.", cql, statement);
        }
        return String.format("Cannot prepare statement %s. Statement must be a SimpleStatement.", statement);
    }
}

