/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;

final class InsertUtil {
    static Insert createInsert(CassandraConverter converter, Object entity) {
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(entity.getClass());
        LinkedHashMap toInsert = new LinkedHashMap();
        converter.write(entity, toInsert, persistentEntity);
        RegularInsert insert = (RegularInsert)QueryBuilder.insertInto((CqlIdentifier)persistentEntity.getTableName());
        for (Map.Entry entry : toInsert.entrySet()) {
            insert = insert.value(CqlIdentifier.fromCql((String)((String)entry.getKey())), (Term)QueryBuilder.literal(entry.getValue()));
        }
        return insert;
    }

    private InsertUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

