/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.support;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.springframework.data.cassandra.core.cql.support.PreparedStatementCache;
import org.springframework.util.Assert;

public class MapPreparedStatementCache
implements PreparedStatementCache {
    private final Map<CacheKey, PreparedStatement> cache;

    private MapPreparedStatementCache(Map<CacheKey, PreparedStatement> cache) {
        Assert.notNull(cache, (String)"Cache must not be null");
        this.cache = cache;
    }

    public static MapPreparedStatementCache create() {
        return MapPreparedStatementCache.of(new ConcurrentHashMap<CacheKey, PreparedStatement>());
    }

    public static MapPreparedStatementCache of(Map<CacheKey, PreparedStatement> cache) {
        return new MapPreparedStatementCache(cache);
    }

    protected Map<CacheKey, PreparedStatement> getCache() {
        return this.cache;
    }

    @Override
    public PreparedStatement getPreparedStatement(CqlSession session, SimpleStatement statement, Supplier<PreparedStatement> preparer) {
        CacheKey cacheKey = new CacheKey(session, statement.toString());
        return this.getCache().computeIfAbsent(cacheKey, key -> (PreparedStatement)preparer.get());
    }

    protected static class CacheKey {
        final String sessionName;
        final String keyspace;
        final String cql;

        CacheKey(CqlSession session, String cql) {
            this.sessionName = session.getName();
            this.keyspace = session.getKeyspace().orElse(CqlIdentifier.fromCql((String)"system")).asInternal();
            this.cql = cql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sessionName = this.sessionName;
            String other$sessionName = other.sessionName;
            if (this$sessionName == null ? other$sessionName != null : !this$sessionName.equals(other$sessionName)) {
                return false;
            }
            String this$keyspace = this.keyspace;
            String other$keyspace = other.keyspace;
            if (this$keyspace == null ? other$keyspace != null : !this$keyspace.equals(other$keyspace)) {
                return false;
            }
            String this$cql = this.cql;
            String other$cql = other.cql;
            return !(this$cql == null ? other$cql != null : !this$cql.equals(other$cql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sessionName = this.sessionName;
            result = result * 59 + ($sessionName == null ? 43 : $sessionName.hashCode());
            String $keyspace = this.keyspace;
            result = result * 59 + ($keyspace == null ? 43 : $keyspace.hashCode());
            String $cql = this.cql;
            result = result * 59 + ($cql == null ? 43 : $cql.hashCode());
            return result;
        }
    }
}

