/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PropertyMapping {
    @Nullable
    private String columnName;
    @Deprecated
    @Nullable
    private String forceQuote;
    private String propertyName;

    public PropertyMapping(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"Property name must not be null");
        this.propertyName = propertyName;
    }

    public PropertyMapping(String propertyName, String columnName) {
        this(propertyName, columnName, "false");
    }

    public PropertyMapping(@NonNull String propertyName, @NonNull String columnName, String forceQuote) {
        Assert.notNull((Object)propertyName, (String)"Property name must not be null");
        this.propertyName = propertyName;
        this.setColumnName(columnName);
        this.setForceQuote(forceQuote);
    }

    @Nullable
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(@NonNull String columnName) {
        Assert.notNull((Object)columnName, (String)"Column name must not be null");
        this.columnName = columnName;
    }

    @Nullable
    @Deprecated
    public String getForceQuote() {
        return this.forceQuote;
    }

    @Deprecated
    public void setForceQuote(String forceQuote) {
        this.forceQuote = forceQuote;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return String.format("{ @type = %1$s, propertyName = %2$s, columnName = %3$s, forceQuote = %4$s }", this.getClass().getName(), this.getPropertyName(), this.getColumnName(), this.getForceQuote());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyMapping)) {
            return false;
        }
        PropertyMapping other = (PropertyMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$forceQuote = this.getForceQuote();
        String other$forceQuote = other.getForceQuote();
        if (this$forceQuote == null ? other$forceQuote != null : !this$forceQuote.equals(other$forceQuote)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        return !(this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $forceQuote = this.getForceQuote();
        result = result * 59 + ($forceQuote == null ? 43 : $forceQuote.hashCode());
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        return result;
    }
}

