/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.converter;

import com.datastax.driver.core.ResultSet;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.cql.converter.ResultSetToListConverter;
import org.springframework.lang.Nullable;

public abstract class AbstractResultSetConverter<T>
implements Converter<ResultSet, T> {
    private static final ResultSetToListConverter converter = new ResultSetToListConverter();

    protected abstract T doConvertSingleValue(Object var1);

    protected abstract Class<?> getType();

    @Nullable
    protected T getNullResultSetValue() {
        return null;
    }

    @Nullable
    protected T getExhaustedResultSetValue() {
        return null;
    }

    public T convert(ResultSet source) {
        if (source.isExhausted()) {
            return this.getExhaustedResultSetValue();
        }
        List<Map<String, Object>> list = converter.convert(source);
        if (list == null) {
            return this.getNullResultSetValue();
        }
        if (list.size() == 1) {
            Map<String, Object> map = list.get(0);
            return map.size() == 1 ? this.doConvertSingleValue(map.get(map.keySet().iterator().next())) : this.doConvertSingleRow(map);
        }
        return this.doConvertResultSet(list);
    }

    protected T doConvertResultSet(List<Map<String, Object>> resultSet) {
        throw new IllegalArgumentException(String.format("Cannot convert %s to desired type [%s]", "result set", this.getType().getName()));
    }

    protected T doConvertSingleRow(Map<String, Object> row) {
        throw new IllegalArgumentException(String.format("Cannot convert %s to desired type [%s]", "row", this.getType().getName()));
    }
}

