/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.config.CassandraClusterFactoryBean;
import org.springframework.data.cassandra.config.ClusterBuilderConfigurer;
import org.springframework.data.cassandra.config.CompressionType;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropKeyspaceSpecification;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Configuration
public abstract class AbstractClusterConfiguration {
    protected Cluster getRequiredCluster() {
        CassandraClusterFactoryBean factoryBean = this.cluster();
        Cluster cluster = factoryBean.getObject();
        Assert.state((cluster != null ? 1 : 0) != 0, (String)"Cluster not initialized");
        return cluster;
    }

    @Bean
    public CassandraClusterFactoryBean cluster() {
        CassandraClusterFactoryBean bean = new CassandraClusterFactoryBean();
        bean.setAddressTranslator(this.getAddressTranslator());
        bean.setAuthProvider(this.getAuthProvider());
        bean.setClusterBuilderConfigurer(this.getClusterBuilderConfigurer());
        bean.setClusterName(this.getClusterName());
        bean.setCompressionType(this.getCompressionType());
        bean.setContactPoints(this.getContactPoints());
        bean.setLoadBalancingPolicy(this.getLoadBalancingPolicy());
        bean.setMaxSchemaAgreementWaitSeconds(this.getMaxSchemaAgreementWaitSeconds());
        bean.setMetricsEnabled(this.getMetricsEnabled());
        bean.setNettyOptions(this.getNettyOptions());
        bean.setPoolingOptions(this.getPoolingOptions());
        bean.setPort(this.getPort());
        bean.setProtocolVersion(this.getProtocolVersion());
        bean.setQueryOptions(this.getQueryOptions());
        bean.setReconnectionPolicy(this.getReconnectionPolicy());
        bean.setRetryPolicy(this.getRetryPolicy());
        bean.setSpeculativeExecutionPolicy(this.getSpeculativeExecutionPolicy());
        bean.setSocketOptions(this.getSocketOptions());
        bean.setTimestampGenerator(this.getTimestampGenerator());
        bean.setKeyspaceCreations(this.getKeyspaceCreations());
        bean.setKeyspaceDrops(this.getKeyspaceDrops());
        bean.setStartupScripts(this.getStartupScripts());
        bean.setShutdownScripts(this.getShutdownScripts());
        return bean;
    }

    @Nullable
    protected AddressTranslator getAddressTranslator() {
        return null;
    }

    @Nullable
    protected AuthProvider getAuthProvider() {
        return null;
    }

    @Nullable
    protected ClusterBuilderConfigurer getClusterBuilderConfigurer() {
        return null;
    }

    @Nullable
    protected String getClusterName() {
        return null;
    }

    @Nullable
    protected CompressionType getCompressionType() {
        return null;
    }

    protected String getContactPoints() {
        return "localhost";
    }

    @Nullable
    protected LoadBalancingPolicy getLoadBalancingPolicy() {
        return null;
    }

    protected int getMaxSchemaAgreementWaitSeconds() {
        return 10;
    }

    protected boolean getMetricsEnabled() {
        return true;
    }

    protected NettyOptions getNettyOptions() {
        return NettyOptions.DEFAULT_INSTANCE;
    }

    @Nullable
    protected PoolingOptions getPoolingOptions() {
        return null;
    }

    protected int getPort() {
        return 9042;
    }

    protected ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.NEWEST_SUPPORTED;
    }

    @Nullable
    protected QueryOptions getQueryOptions() {
        return null;
    }

    @Nullable
    protected ReconnectionPolicy getReconnectionPolicy() {
        return null;
    }

    @Nullable
    protected RetryPolicy getRetryPolicy() {
        return null;
    }

    @Nullable
    protected SpeculativeExecutionPolicy getSpeculativeExecutionPolicy() {
        return null;
    }

    @Nullable
    protected SocketOptions getSocketOptions() {
        return null;
    }

    @Nullable
    protected TimestampGenerator getTimestampGenerator() {
        return null;
    }

    protected List<CreateKeyspaceSpecification> getKeyspaceCreations() {
        return Collections.emptyList();
    }

    protected List<DropKeyspaceSpecification> getKeyspaceDrops() {
        return Collections.emptyList();
    }

    protected List<String> getStartupScripts() {
        return Collections.emptyList();
    }

    protected List<String> getShutdownScripts() {
        return Collections.emptyList();
    }
}

