/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.repository.query.CassandraEntityMetadata;
import org.springframework.util.Assert;

class SimpleCassandraEntityMetadata<T>
implements CassandraEntityMetadata<T> {
    private final CassandraPersistentEntity<?> entity;
    private final Class<T> type;

    SimpleCassandraEntityMetadata(Class<T> type, CassandraPersistentEntity<?> entity) {
        Assert.notNull(type, (String)"Type must not be null");
        Assert.notNull(entity, (String)"Collection entity must not be null or empty");
        this.type = type;
        this.entity = entity;
    }

    @Override
    public CqlIdentifier getTableName() {
        return this.entity.getTableName();
    }

    public Class<T> getJavaType() {
        return this.type;
    }
}

