/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.FluentCassandraOperations;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.domain.Slice;
import org.springframework.lang.Nullable;

public interface CassandraOperations
extends FluentCassandraOperations {
    public CassandraBatchOperations batchOps();

    public CassandraConverter getConverter();

    public CqlOperations getCqlOperations();

    public CqlIdentifier getTableName(Class<?> var1);

    public <T> List<T> select(String var1, Class<T> var2) throws DataAccessException;

    public <T> Stream<T> stream(String var1, Class<T> var2) throws DataAccessException;

    @Nullable
    public <T> T selectOne(String var1, Class<T> var2) throws DataAccessException;

    public <T> List<T> select(Statement var1, Class<T> var2) throws DataAccessException;

    public <T> Slice<T> slice(Statement var1, Class<T> var2) throws DataAccessException;

    public <T> Stream<T> stream(Statement var1, Class<T> var2) throws DataAccessException;

    @Nullable
    public <T> T selectOne(Statement var1, Class<T> var2) throws DataAccessException;

    public <T> List<T> select(Query var1, Class<T> var2) throws DataAccessException;

    public <T> Slice<T> slice(Query var1, Class<T> var2) throws DataAccessException;

    public <T> Stream<T> stream(Query var1, Class<T> var2) throws DataAccessException;

    @Nullable
    public <T> T selectOne(Query var1, Class<T> var2) throws DataAccessException;

    public boolean update(Query var1, Update var2, Class<?> var3) throws DataAccessException;

    public boolean delete(Query var1, Class<?> var2) throws DataAccessException;

    public long count(Class<?> var1) throws DataAccessException;

    public long count(Query var1, Class<?> var2) throws DataAccessException;

    public boolean exists(Object var1, Class<?> var2) throws DataAccessException;

    public boolean exists(Query var1, Class<?> var2) throws DataAccessException;

    @Nullable
    public <T> T selectOneById(Object var1, Class<T> var2) throws DataAccessException;

    public <T> T insert(T var1) throws DataAccessException;

    public <T> EntityWriteResult<T> insert(T var1, InsertOptions var2) throws DataAccessException;

    public <T> T update(T var1) throws DataAccessException;

    public <T> EntityWriteResult<T> update(T var1, UpdateOptions var2) throws DataAccessException;

    public void delete(Object var1) throws DataAccessException;

    public WriteResult delete(Object var1, QueryOptions var2) throws DataAccessException;

    public boolean deleteById(Object var1, Class<?> var2) throws DataAccessException;

    public void truncate(Class<?> var1) throws DataAccessException;
}

