/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.UserType;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.UserDefinedType;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraUserTypePersistentEntity<T>
extends BasicCassandraPersistentEntity<T> {
    private final UserTypeResolver resolver;
    private final Object lock = new Object();
    @Nullable
    private volatile UserType userType;

    public CassandraUserTypePersistentEntity(TypeInformation<T> typeInformation, CassandraPersistentEntityMetadataVerifier verifier, UserTypeResolver resolver) {
        super(typeInformation, verifier);
        Assert.notNull((Object)resolver, (String)"UserTypeResolver must not be null");
        this.resolver = resolver;
    }

    @Override
    protected CqlIdentifier determineTableName() {
        UserDefinedType annotation = (UserDefinedType)this.findAnnotation(UserDefinedType.class);
        if (annotation != null) {
            return this.determineName(annotation.value(), annotation.forceQuote());
        }
        return super.determineTableName();
    }

    @Override
    public boolean isUserDefinedType() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserType getUserType() {
        if (this.userType == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.userType == null) {
                    CqlIdentifier identifier = this.determineTableName();
                    UserType userType = this.resolver.resolveType(identifier);
                    if (userType == null) {
                        throw new MappingException(String.format("User type [%s] not found", identifier));
                    }
                    this.userType = userType;
                }
            }
        }
        return this.userType;
    }
}

