/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import lombok.NonNull;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.ReactiveUpdateOperation;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class ReactiveUpdateOperationSupport
implements ReactiveUpdateOperation {
    @NonNull
    private final ReactiveCassandraTemplate template;

    @Override
    public ReactiveUpdateOperation.ReactiveUpdate update(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveUpdateSupport(this.template, domainType, Query.empty(), null);
    }

    public ReactiveUpdateOperationSupport(@NonNull ReactiveCassandraTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked @NonNull but is null");
        }
        this.template = template;
    }

    static class ReactiveUpdateSupport
    implements ReactiveUpdateOperation.ReactiveUpdate,
    ReactiveUpdateOperation.TerminatingUpdate {
        @NonNull
        private final ReactiveCassandraTemplate template;
        @NonNull
        private final Class<?> domainType;
        @NonNull
        private final Query query;
        @Nullable
        private final CqlIdentifier tableName;

        @Override
        public ReactiveUpdateOperation.UpdateWithQuery inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveUpdateSupport(this.template, this.domainType, this.query, tableName);
        }

        @Override
        public ReactiveUpdateOperation.TerminatingUpdate matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ReactiveUpdateSupport(this.template, this.domainType, query2, this.tableName);
        }

        @Override
        public Mono<WriteResult> apply(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null");
            return this.template.doUpdate(this.query, update, this.domainType, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }

        public ReactiveUpdateSupport(@NonNull ReactiveCassandraTemplate template, @NonNull Class<?> domainType, @NonNull Query query2, @Nullable CqlIdentifier tableName) {
            if (template == null) {
                throw new NullPointerException("template is marked @NonNull but is null");
            }
            if (domainType == null) {
                throw new NullPointerException("domainType is marked @NonNull but is null");
            }
            if (query2 == null) {
                throw new NullPointerException("query is marked @NonNull but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query2;
            this.tableName = tableName;
        }
    }
}

